/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.dex.base.DexException;
import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.data.Def;
import com.reandroid.dex.data.StaticFieldDefArray;
import com.reandroid.dex.id.FieldId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.NullValueKey;
import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.FieldProgram;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliField;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public class FieldDef
extends Def<FieldId>
implements FieldProgram {
    private Key cachedStaticValue;

    public FieldDef() {
        super(0, SectionType.FIELD_ID);
    }

    @Override
    public FieldKey getKey() {
        FieldId id = (FieldId)this.getId();
        if (id != null) {
            return id.getKey();
        }
        return null;
    }

    @Override
    public Key getStaticValue() {
        StaticFieldDefArray fieldDefArray = this.getParentInstance(StaticFieldDefArray.class);
        if (fieldDefArray != null) {
            return fieldDefArray.getStaticValue(this);
        }
        return null;
    }

    public void setStaticValue(Key staticValue) {
        StaticFieldDefArray fieldDefArray = this.getParentInstance(StaticFieldDefArray.class);
        if (fieldDefArray == null) {
            throw new DexException("Not a member of StaticFieldDefArray: " + Modifier.toString(this.getModifiers()) + this.getKey());
        }
        fieldDefArray.setStaticValue(this, staticValue);
        this.validateStaticValue();
    }

    Key cachedStaticValue() {
        return this.cachedStaticValue;
    }

    void cachedStaticValue(Key staticValue) {
        this.cachedStaticValue = staticValue;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        FieldKey key = this.getKey();
        if (key == null) {
            throw new IOException("Null FieldKey");
        }
        writer.newLine();
        this.getSmaliDirective().append(writer);
        writer.appendModifiers(this.getModifiers());
        key.appendDefinition(writer);
        this.appendStaticValue(writer);
        AnnotationSetKey annotations = this.getAnnotation();
        if (annotations.isEmpty()) {
            return;
        }
        writer.indentPlus();
        annotations.append(writer);
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    private void appendStaticValue(SmaliWriter writer) throws IOException {
        Key value = this.getStaticValue();
        if (value == null) {
            return;
        }
        if (this.isNonDefaultValue(value) || !this.isInitializedInStaticConstructor()) {
            writer.append(" = ");
            value.append(writer);
        }
    }

    private boolean isNonDefaultValue(Key key) {
        if (key instanceof PrimitiveKey) {
            PrimitiveKey primitiveKey = (PrimitiveKey)key;
            return primitiveKey.getValueAsLong() != 0L;
        }
        return !(key instanceof NullValueKey);
    }

    public boolean isInitializedInStaticConstructor() {
        StaticFieldDefArray fieldDefArray = this.getParentInstance(StaticFieldDefArray.class);
        if (fieldDefArray != null) {
            return fieldDefArray.isInitializedInStaticConstructor(this);
        }
        return false;
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return SingleIterator.of(this.getId());
    }

    @Override
    public boolean uses(Key key) {
        return key.equals(this.getStaticValue());
    }

    @Override
    public Iterator<Key> usedKeys() {
        return CombiningIterator.singleOne(this.getKey(), SingleIterator.of(this.getStaticValue()));
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.validateStaticValue();
    }

    public void validateStaticValue() {
        Key staticValue = this.getStaticValue();
        if (staticValue == null) {
            return;
        }
        FieldKey fieldKey = this.getKey();
        if (!this.isStatic()) {
            throw new DexException("Instance field could not have initial value: " + Modifier.toString(this.getAccessFlags()) + " " + fieldKey + " = " + SmaliWriter.toStringSafe(staticValue));
        }
        TypeKey typeKey = fieldKey.getType();
        if (typeKey.isPrimitive() != staticValue instanceof PrimitiveKey) {
            throw new DexException("Mismatch in type object vs primitive for value: " + SmaliWriter.toStringSafe(staticValue) + ", in field: " + fieldKey + "\n");
        }
        if (staticValue instanceof PrimitiveKey) {
            TypeKey valueType = ((PrimitiveKey)staticValue).valueType();
            if (!typeKey.equals(valueType)) {
                throw new DexException("Mismatch in type: " + typeKey + " vs " + valueType + ", for value: " + SmaliWriter.toStringSafe(staticValue) + ", in field: " + fieldKey);
            }
        } else if (typeKey.isPrimitive()) {
            throw new DexException("Mismatch in type: " + typeKey + " vs L , for value: " + SmaliWriter.toStringSafe(staticValue) + ", in field: " + fieldKey);
        }
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.FIELD;
    }

    @Override
    public void merge(Def<?> def) {
        super.merge(def);
        FieldDef comingField = (FieldDef)def;
        Key staticValue = comingField.getStaticValue();
        if (staticValue != null) {
            this.setStaticValue(staticValue);
        }
    }

    @Override
    public void fromSmali(Smali smali) {
        Key value;
        SmaliField smaliField = (SmaliField)smali;
        this.setKey(smaliField.getKey());
        this.setAccessFlagsValue(smaliField.getAccessFlagsValue());
        this.addHiddenApiFlags(smaliField.getHiddenApiFlags());
        if (smaliField.hasAnnotation()) {
            this.setAnnotation(smaliField.getAnnotationSetKey());
        }
        if ((value = smaliField.getStaticValue()) != null) {
            this.setStaticValue(value);
        }
    }

    @Override
    public SmaliField toSmali() {
        SmaliField smaliField = new SmaliField();
        smaliField.setKey(this.getKey());
        smaliField.setAccessFlags(AccessFlag.valuesOfField(this.getAccessFlagsValue()));
        smaliField.setStaticValue(this.getStaticValue());
        smaliField.setAnnotation(this.getAnnotationKeys());
        return smaliField;
    }

    public String toString() {
        return SmaliWriter.toStringSafe(this);
    }
}

