/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.base.PositionAlignedItem;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.FullRefresh;
import com.reandroid.dex.data.AnnotationElement;
import com.reandroid.dex.data.AnnotationItem;
import com.reandroid.dex.data.IntegerDataItemList;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.AnnotatedProgram;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliAnnotationItem;
import com.reandroid.dex.smali.model.SmaliAnnotationSet;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Predicate;

public class AnnotationSet
extends IntegerDataItemList<AnnotationItem>
implements KeyReference,
SmaliFormat,
PositionAlignedItem,
FullRefresh,
AnnotatedProgram {
    public AnnotationSet() {
        super(SectionType.ANNOTATION_ITEM, UsageMarker.USAGE_ANNOTATION, new DexPositionAlign());
    }

    public boolean remove(TypeKey typeKey) {
        return this.removeIf(item -> ObjectsUtil.equals(typeKey, item.getType()));
    }

    public boolean remove(AnnotationItemKey itemKey) {
        return this.removeIf(item -> ObjectsUtil.equals(itemKey, item.getKey()));
    }

    @Override
    public boolean removeAnnotationIf(Predicate<? super AnnotationItemKey> predicate) {
        return this.removeIf(item -> predicate.test(item.getKey()));
    }

    @Override
    public boolean isBlank() {
        return this.isEmpty();
    }

    @Override
    public AnnotationSetKey getKey() {
        Key[] elements = new AnnotationItemKey[this.size()];
        this.getItemKeys(elements);
        return this.checkKey(AnnotationSetKey.of((AnnotationItemKey[])elements));
    }

    @Override
    public void setKey(Key key) {
        super.setKey(key);
    }

    public SectionType<AnnotationSet> getSectionType() {
        return SectionType.ANNOTATION_SET;
    }

    @Override
    public AnnotationItemKey getItemKey(int i) {
        return (AnnotationItemKey)super.getItemKey(i);
    }

    public DexValueBlock<?> getValue(TypeKey typeKey, String name) {
        AnnotationElement element = this.getElement(typeKey, name);
        if (element != null) {
            return element.getValueBlock();
        }
        return null;
    }

    public AnnotationElement getElement(TypeKey typeKey, String name) {
        AnnotationItem annotationItem = this.get(typeKey);
        if (annotationItem != null) {
            return annotationItem.getElement(name);
        }
        return null;
    }

    public AnnotationItem get(TypeKey typeKey) {
        for (AnnotationItem item : this) {
            if (!typeKey.equals(item.getType())) continue;
            return item;
        }
        return null;
    }

    public Iterator<AnnotationItem> getAll(TypeKey typeKey) {
        return FilterIterator.of(this.iterator(), item -> typeKey.equals(item.getType()));
    }

    public boolean contains(TypeKey typeKey) {
        for (AnnotationItem item : this) {
            if (!typeKey.equals(item.getType())) continue;
            return true;
        }
        return false;
    }

    public AnnotationItem getOrCreate(TypeKey typeKey) {
        AnnotationItem item = this.get(typeKey);
        if (item != null) {
            return item;
        }
        return this.addNewItem(typeKey);
    }

    public AnnotationItem getOrCreate(TypeKey type, String name) {
        AnnotationItem item = this.get(type, name);
        if (item != null) {
            return item;
        }
        return this.addNew(type, name);
    }

    private AnnotationItem addNewItem(TypeKey typeKey) {
        AnnotationItem item = (AnnotationItem)this.addNewItem();
        item.setType(typeKey);
        return item;
    }

    private AnnotationItem addNew(TypeKey type, String name) {
        AnnotationItem item = this.getOrCreate(type);
        item.getOrCreateElement(name);
        return item;
    }

    public AnnotationItem get(TypeKey type, String name) {
        for (AnnotationItem item : this) {
            if (!type.equals(item.getType()) || !item.containsName(name)) continue;
            return item;
        }
        return null;
    }

    public AnnotationItem getOrCreate(AnnotationItemKey annotationItemKey) {
        AnnotationItem item = this.get(annotationItemKey);
        if (item == null) {
            item = (AnnotationItem)this.addNewItem(annotationItemKey);
        }
        return item;
    }

    public AnnotationItem get(AnnotationItemKey annotationItemKey) {
        for (AnnotationItem item : this) {
            if (!annotationItemKey.equals(item.getKey())) continue;
            return item;
        }
        return null;
    }

    public void replaceKeys(Key search, Key replace) {
        for (AnnotationItem annotationItem : this) {
            annotationItem.replaceKeys(search, replace);
        }
    }

    @Override
    public void refreshFull() {
        this.sort();
    }

    public boolean sort() {
        return super.sort(CollectionUtil.getComparator());
    }

    @Override
    public AnnotationSetKey getAnnotation() {
        return this.getKey();
    }

    @Override
    public void setAnnotation(AnnotationSetKey annotationSet) {
        this.setKey(annotationSet);
    }

    @Override
    public void clearAnnotations() {
        this.clear();
    }

    @Override
    public boolean hasAnnotations() {
        return !this.isEmpty();
    }

    @Override
    public boolean hasAnnotation(TypeKey typeKey) {
        return this.contains(typeKey);
    }

    @Override
    public AnnotationItemKey getAnnotation(TypeKey typeKey) {
        AnnotationItem item = this.get(typeKey);
        if (item != null) {
            return item.getKey();
        }
        return null;
    }

    @Override
    public boolean removeAnnotation(TypeKey typeKey) {
        return this.remove(typeKey);
    }

    @Override
    public void addAnnotation(AnnotationItemKey annotation) {
        this.remove(annotation.getType());
        ((AnnotationItem)this.addNewItem()).setKey(annotation);
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return new IterableIterator<AnnotationItem, IdItem>(this.iterator()){

            @Override
            public Iterator<IdItem> iterator(AnnotationItem element) {
                return element.usedIds();
            }
        };
    }

    public void merge(AnnotationSet annotationSet) {
        if (annotationSet == this) {
            return;
        }
        for (AnnotationItem coming : annotationSet) {
            this.addNewItem(coming.getKey());
        }
    }

    public void fromSmali(SmaliAnnotationSet smaliAnnotationSet) {
        Iterator iterator = smaliAnnotationSet.iterator();
        while (iterator.hasNext()) {
            SmaliAnnotationItem smaliAnnotationItem = (SmaliAnnotationItem)iterator.next();
            this.getOrCreate(smaliAnnotationItem.getKey());
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendAllWithDoubleNewLine(this.iterator());
    }

    public String toString() {
        if (this.getOffsetReference() == null) {
            return super.toString();
        }
        int size = this.size();
        if (size == 0) {
            return "EMPTY";
        }
        StringBuilder builder = new StringBuilder();
        boolean appendOnce = false;
        for (AnnotationItem item : this) {
            if (appendOnce) {
                builder.append(',');
            }
            builder.append(item);
            appendOnce = true;
        }
        return builder.toString();
    }

    public static class EmptyAnnotationSet
    extends AnnotationSet {
        public EmptyAnnotationSet() {
            this.addUsageType(UsageMarker.USAGE_ANNOTATION);
        }

        @Override
        public boolean isBlank() {
            return this.isRemoved();
        }

        @Override
        protected void onRefreshed() {
            super.onRefreshed();
            Section<AnnotationSet> section = this.getSection(this.getSectionType());
            if (section.getCount() == 1) {
                this.addUsageType(UsageMarker.USAGE_ANNOTATION);
            }
        }

        @Override
        public void clearUsageType() {
            Section<AnnotationSet> section = this.getSection(this.getSectionType());
            if (section.getCount() != 1) {
                super.clearUsageType();
            }
        }
    }
}

