/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dalvik;

import com.reandroid.dex.common.AnnotationVisibility;
import com.reandroid.dex.dalvik.DalvikAnnotation;
import com.reandroid.dex.key.AnnotationElementKey;
import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.ArrayKey;
import com.reandroid.dex.key.ArrayValueKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.AnnotatedProgram;
import com.reandroid.dex.program.ClassProgram;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.CollectionUtil;
import java.util.Iterator;
import java.util.function.Predicate;

public class DalvikMemberClass
extends DalvikAnnotation {
    private DalvikMemberClass(AnnotatedProgram annotatedProgram) {
        super(annotatedProgram, TypeKey.DALVIK_MemberClass);
    }

    public Iterator<TypeKey> getMembers() {
        return this.getArray().iterator(TypeKey.class);
    }

    public int size() {
        return this.getArray().size();
    }

    public void add(TypeKey typeKey) {
        ArrayKey array = this.getArray().remove(typeKey).add(typeKey).sort(CompareUtil.getComparableComparator());
        this.setArray((ArrayValueKey)array);
    }

    public void remove(TypeKey typeKey) {
        ArrayValueKey array = this.getArray().remove(typeKey).add(typeKey);
        this.setArray(array);
    }

    public void removeIf(Predicate<? super TypeKey> predicate) {
        ArrayKey array = this.getArray().removeIf((Predicate)ObjectsUtil.cast(predicate));
        this.setArray((ArrayValueKey)array);
    }

    public boolean contains(TypeKey typeKey) {
        return this.getArray().contains(typeKey);
    }

    public boolean isEmpty() {
        return this.getArray().isEmpty();
    }

    public TypeKey findEnclosing() {
        TypeKey enclosing;
        AnnotatedProgram annotatedProgram = this.getAnnotatedProgram();
        if (annotatedProgram instanceof ClassProgram) {
            enclosing = ((ClassProgram)this.getAnnotatedProgram()).getKey();
        } else {
            enclosing = CollectionUtil.getFirst(this.getMembers());
            if (enclosing != null) {
                enclosing = enclosing.getEnclosingClass();
            }
        }
        return enclosing;
    }

    public void addSimpleName(String simpleName) {
        this.addSimpleName(this.findEnclosing(), simpleName);
    }

    public void addSimpleName(TypeKey enclosing, String simpleName) {
        if (enclosing == null) {
            throw new NullPointerException("Null enclosing type");
        }
        enclosing = enclosing.createInnerClass(simpleName);
        this.add(enclosing);
    }

    public ArrayValueKey getArray() {
        ArrayValueKey arrayValueKey = (ArrayValueKey)this.readValue(Key.DALVIK_value);
        if (arrayValueKey == null) {
            arrayValueKey = ArrayValueKey.empty();
        }
        return arrayValueKey;
    }

    public void setArray(ArrayValueKey array) {
        if (array == null) {
            array = ArrayValueKey.empty();
        }
        this.writeValue(Key.DALVIK_value, array);
    }

    @Override
    public String toString() {
        return StringsUtil.join(this.getMembers(), (Object)"\n");
    }

    public static DalvikMemberClass of(AnnotatedProgram annotatedProgram) {
        if (annotatedProgram.hasAnnotation(TypeKey.DALVIK_MemberClass)) {
            return new DalvikMemberClass(annotatedProgram);
        }
        return null;
    }

    public static DalvikMemberClass getOrCreate(AnnotatedProgram annotatedProgram) {
        if (!annotatedProgram.hasAnnotation(TypeKey.DALVIK_MemberClass)) {
            annotatedProgram.addAnnotation(AnnotationItemKey.create(AnnotationVisibility.SYSTEM, TypeKey.DALVIK_MemberClass, AnnotationElementKey.create(Key.DALVIK_value, ArrayValueKey.empty())));
        }
        return DalvikMemberClass.of(annotatedProgram);
    }
}

