/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.common;

import com.reandroid.dex.common.Register;
import com.reandroid.dex.ins.RegistersSet;
import java.util.Iterator;

public interface RegistersTable {
    public int getRegistersCount();

    public int getParameterRegistersCount();

    public void setRegistersCount(int var1);

    public void setParameterRegistersCount(int var1);

    public boolean ensureLocalRegistersCount(int var1);

    default public int getLocalRegistersCount() {
        return this.getRegistersCount() - this.getParameterRegistersCount();
    }

    default public Register getRegisterFor(int registerValue) {
        boolean parameter = false;
        int local = this.getLocalRegistersCount();
        if (registerValue >= local) {
            registerValue -= local;
            parameter = true;
        }
        return new Register(registerValue, parameter);
    }

    default public int getRegisterValue(Register register) {
        int result = register.getNumber();
        if (register.isParameter()) {
            result += this.getLocalRegistersCount();
        }
        return result;
    }

    default public Iterator<Register> getRegisters(final RegistersSet registersSet) {
        return new Iterator<Register>(){
            private int mIndex;

            @Override
            public boolean hasNext() {
                return this.mIndex < registersSet.getRegistersCount();
            }

            @Override
            public Register next() {
                return RegistersTable.this.getRegisterFor(registersSet.getRegister(this.mIndex++));
            }
        };
    }
}

