/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.common;

import com.reandroid.dex.common.RegisterType;

public class RegisterFormat {
    public static final RegisterFormat NONE = new RegisterFormat("NONE", new RegisterType[0]);
    public static final RegisterFormat READ = new RegisterFormat("READ", new RegisterType[]{RegisterType.READ});
    public static final RegisterFormat WRITE = new RegisterFormat("WRITE", new RegisterType[]{RegisterType.WRITE});
    public static final RegisterFormat READ_READ = new RegisterFormat("READ_READ", new RegisterType[]{RegisterType.READ, RegisterType.READ});
    public static final RegisterFormat READ_WRITE = new RegisterFormat("READ_WRITE", new RegisterType[]{RegisterType.READ, RegisterType.WRITE});
    public static final RegisterFormat READ_READ_READ = new RegisterFormat("READ_READ_READ", new RegisterType[]{RegisterType.READ, RegisterType.READ, RegisterType.READ});
    public static final RegisterFormat WRITE_READ = new RegisterFormat("WRITE_READ", new RegisterType[]{RegisterType.WRITE, RegisterType.READ});
    public static final RegisterFormat WRITE_READ_READ = new RegisterFormat("WRITE_READ_READ", new RegisterType[]{RegisterType.WRITE, RegisterType.READ, RegisterType.READ});
    public static final RegisterFormat OUT = new RegisterFormat("OUT", new RegisterType[0]){

        @Override
        public RegisterType get(int i) {
            return RegisterType.READ;
        }

        @Override
        public boolean isOut() {
            return true;
        }
    };
    public static final RegisterFormat OUT_RANGE = new RegisterFormat("OUT_RANGE", new RegisterType[]{RegisterType.READ, RegisterType.READ}){

        @Override
        public boolean isOut() {
            return true;
        }

        @Override
        public boolean isRange() {
            return true;
        }
    };
    private final String name;
    private final RegisterType[] types;
    private final int hash;

    private RegisterFormat(String name, RegisterType[] types) {
        this.name = name;
        this.types = types;
        int h = 1;
        if (types != null) {
            h += 31 * types.length;
        }
        this.hash = h += 31 * name.hashCode();
    }

    public RegisterType get(int i) {
        if (this.isOut()) {
            return RegisterType.READ;
        }
        return this.types[i];
    }

    public int size() {
        RegisterType[] types = this.types;
        if (types != null) {
            return types.length;
        }
        return 0;
    }

    public boolean isOut() {
        return false;
    }

    public boolean isRange() {
        return false;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.name;
    }
}

