/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.base;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockArray;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.base.OffsetSupplier;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.DexArraySupplier;
import com.reandroid.dex.base.FixedSizeBlock;
import com.reandroid.dex.base.IntegerPair;
import com.reandroid.dex.base.PositionedItem;
import com.reandroid.dex.header.DexHeader;
import java.io.IOException;

public class BlockListArray<T extends Block>
extends BlockArray<T>
implements OffsetSupplier,
DexArraySupplier<T>,
Creator<T> {
    private final IntegerPair countAndOffset;

    public BlockListArray(IntegerPair countAndOffset, Creator<T> creator) {
        super(creator);
        this.countAndOffset = countAndOffset;
    }

    @Override
    public int countBytes() {
        Object item = this.getFirst();
        if (item instanceof FixedSizeBlock) {
            return ((Block)item).countBytes() * this.getCount();
        }
        return super.countBytes();
    }

    @Override
    public IntegerReference getOffsetReference() {
        return this.getCountAndOffset().getSecond();
    }

    public IntegerPair getCountAndOffset() {
        return this.countAndOffset;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        IntegerPair countAndOffset = this.getCountAndOffset();
        if (this.skipReading(countAndOffset, reader)) {
            return;
        }
        this.readChildes(reader);
        this.trimToSize();
    }

    public void readChild(BlockReader reader, T item) throws IOException {
        this.positionItem((Block)item, reader);
        ((Block)item).readBytes(reader);
    }

    private boolean skipReading(IntegerPair countAndOffset, BlockReader reader) {
        if (countAndOffset == null) {
            return false;
        }
        IntegerReference reference = countAndOffset.getSecond();
        if (reference != null) {
            int offset = reference.get();
            if (!this.isValidOffset(offset)) {
                return true;
            }
            reader.seek(offset);
        }
        return false;
    }

    @Override
    public void readChildes(BlockReader reader) throws IOException {
        int count = this.countAndOffset.getFirst().get();
        this.setSize(count);
        for (int i = 0; i < count; ++i) {
            Object item = this.get(i);
            this.readChild(reader, item);
        }
        this.onChanged();
    }

    private void positionItem(Block block, BlockReader reader) {
        if (!(block instanceof PositionedItem)) {
            return;
        }
        PositionedItem positionedItem = (PositionedItem)((Object)block);
        positionedItem.setPosition(reader.getPosition());
    }

    protected boolean isValidOffset(int offset) {
        if (offset == 0) {
            return this.isDexHeaderArray();
        }
        return offset > 0;
    }

    private boolean isDexHeaderArray() {
        return this.get(0) instanceof DexHeader;
    }

    @Override
    protected void onRefreshed() {
        this.updateCount();
        super.onRefreshed();
    }

    protected void updateCount() {
        IntegerReference count = this.getCountAndOffset().getFirst();
        count.set(this.size());
    }

    @Override
    public T newInstance() {
        return this.getCreator().newInstance();
    }
}

