/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.commons.utils.log;

import com.reandroid.commons.utils.log.WriterLogger;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.io.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileLogger
extends WriterLogger {
    private final Object mLock = new Object();
    private File mFile;
    private static final int MAX_LINES = 25000;

    public FileLogger(File file) throws IOException {
        super(FileLogger.createWriter(file), FileLogger.countLines(file));
        this.mFile = file;
    }

    public File getFile() {
        return this.mFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFile(File file) throws IOException {
        File prev = this.getFile();
        if (ObjectsUtil.equals(prev, file)) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            Writer writer = FileLogger.createWriter(file);
            super.setWriter(writer);
            super.resetCount();
            writer.write("// Previous file: " + prev);
            writer.flush();
            this.mFile = file;
            return true;
        }
    }

    @Override
    void onTotalCount(Writer writer, int totalCount) {
        if (totalCount < 25000) {
            return;
        }
        File newFile = FileLogger.getLastNumberedFile(this.getFile());
        newFile = FileLogger.getNextNumberedFile(newFile);
        try {
            if (this.setFile(newFile)) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return ObjectsUtil.equals(this.getFile(), ((FileLogger)o).getFile());
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.getFile());
    }

    public String toString() {
        return "FileLogger{" + this.getFile() + '}';
    }

    private static Writer createWriter(File file) throws IOException {
        return new OutputStreamWriter(FileUtil.outputStream(file), StandardCharsets.UTF_8);
    }

    public static FileLogger create(File file) {
        try {
            file = FileLogger.getLastNumberedFile(file);
            file = FileLogger.prepare(file);
            FileLogger fileLogger = new FileLogger(file);
            fileLogger.setEnable(true);
            fileLogger.setIgnoreSameLine(true);
            return fileLogger;
        }
        catch (IOException exception) {
            return null;
        }
    }

    public static File prepare(File file) {
        FileUtil.ensureParentDirectory(file);
        int lines = FileLogger.countLines(file);
        if (lines < 25000) {
            return file;
        }
        File next = FileLogger.getNextNumberedFile(file);
        if (file.equals(next)) {
            return file;
        }
        return FileLogger.prepare(next);
    }

    private static int countLines(File file) {
        try {
            return FileLogger.countContentLines(file);
        }
        catch (IOException exception) {
            return 0;
        }
    }

    private static int countContentLines(File file) throws IOException {
        if (file == null) {
            throw new IOException("file == null");
        }
        if (!file.isFile()) {
            return 0;
        }
        int result = 0;
        InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(file));
        BufferedReader reader = new BufferedReader(inputStreamReader);
        while (reader.readLine() != null) {
            ++result;
        }
        reader.close();
        return result;
    }

    public static File getNextNumberedFile(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        String ext = "";
        int i = name.lastIndexOf(".");
        if (i > 0) {
            ext = name.substring(i);
            name = name.substring(0, i);
        }
        i = FileLogger.getLastNum(name) + 1;
        name = FileLogger.removeLastNum(name);
        File dir = file.getParentFile();
        return new File(dir, FileLogger.buildNumberFileName(name, i, ext));
    }

    public static File getLastNumberedFile(File file) {
        File dir;
        File[] files;
        if (file == null) {
            return null;
        }
        if (!file.isFile()) {
            return file;
        }
        String name = file.getName();
        String ext = "";
        int i = name.lastIndexOf(".");
        if (i > 0) {
            ext = name.substring(i);
            name = name.substring(0, i);
        }
        if ((files = (dir = file.getParentFile()).listFiles()) == null) {
            return file;
        }
        i = FileLogger.getLastNum(name) + 1;
        name = FileLogger.removeLastNum(name);
        File result = file;
        for (File f : files) {
            int i2;
            String n;
            if (!f.isFile() || !(n = f.getName()).startsWith(name) || !n.endsWith(ext) || (i2 = FileLogger.getLastNum(f)) <= i) continue;
            result = f;
            i = i2;
        }
        return result;
    }

    private static int getLastNum(File file) {
        Pattern pattern;
        Matcher matcher;
        String name = file.getName();
        int i = name.lastIndexOf(".");
        if (i > 0) {
            name = name.substring(0, i);
        }
        if (!(matcher = (pattern = Pattern.compile("^.+_([0-9]{1,6})$")).matcher(name)).find()) {
            return 0;
        }
        String num = matcher.group(1);
        return Integer.parseInt(num);
    }

    private static String buildNumberFileName(String name, int i, String ext) {
        String num = i < 10000 ? String.format("%04d", i) : String.valueOf(i);
        return name + "_" + num + ext;
    }

    private static String removeLastNum(String name) {
        Pattern pattern = Pattern.compile("^.+(_[0-9]{1,6})$");
        Matcher matcher = pattern.matcher(name);
        if (!matcher.find()) {
            return name;
        }
        String num = matcher.group(1);
        int i = name.length() - num.length();
        return name.substring(0, i);
    }

    private static int getLastNum(String name) {
        Pattern pattern = Pattern.compile("^.+_([0-9]{1,6})$");
        Matcher matcher = pattern.matcher(name);
        if (!matcher.find()) {
            return 0;
        }
        String num = matcher.group(1);
        return Integer.parseInt(num);
    }
}

