/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.common;

import com.reandroid.common.BytesInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class BytesOutputStream
extends ByteArrayOutputStream {
    private int mLastGrow;

    public BytesOutputStream(int initialCapacity) {
        super(BytesOutputStream.check(initialCapacity));
    }

    private static int check(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Negative: " + i);
        }
        return i;
    }

    public BytesOutputStream() {
        this(32);
    }

    public int position() {
        return this.size();
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (len == 0) {
            return;
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        if (this.mLastGrow == 0) {
            this.mLastGrow = 1;
            this.mLastGrow <<= 1;
        }
        this.mLastGrow <<= 1;
        if (this.mLastGrow > 65535) {
            this.mLastGrow = 65535;
        }
        byte[] buf = this.buf;
        int oldCapacity = buf.length;
        int newCapacity = minCapacity + this.mLastGrow;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        byte[] bytes = new byte[newCapacity];
        for (int i = 0; i < oldCapacity; ++i) {
            bytes[i] = buf[i];
        }
        this.buf = bytes;
    }

    public void write(InputStream inputStream) throws IOException {
        int length;
        if (inputStream instanceof BytesInputStream) {
            this.write((BytesInputStream)inputStream);
            return;
        }
        int bufferStep = 500;
        int maxBuffer = 81920;
        byte[] buffer = new byte[2048];
        while ((length = inputStream.read(buffer, 0, buffer.length)) >= 0) {
            this.write(buffer, 0, length);
            if (buffer.length >= maxBuffer) continue;
            buffer = new byte[buffer.length + bufferStep];
        }
        inputStream.close();
    }

    public void write(BytesInputStream bis) throws IOException {
        byte[] bytes = bis.toByteArray();
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public synchronized byte[] toByteArray() {
        int count = this.count;
        byte[] buf = this.buf;
        if (count == buf.length) {
            return buf;
        }
        if (count == 0) {
            this.buf = buf = new byte[0];
            return buf;
        }
        byte[] results = new byte[count];
        for (int i = 0; i < count; ++i) {
            results[i] = buf[i];
        }
        this.buf = results;
        return results;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.toByteArray();
    }

    @Override
    public String toString() {
        return "pos = " + this.size();
    }
}

