/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value.attribute;

import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.AttributeType;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.utils.HexUtil;
import java.util.List;

public class AttributeBagItem {
    private final ResValueMap mBagItem;

    public AttributeBagItem(ResValueMap bagItem) {
        this.mBagItem = bagItem;
    }

    public int getData() {
        return this.getBagItem().getData();
    }

    public String getNameOrHex() {
        String name = this.getName();
        if (name == null) {
            name = ValueCoder.decodeUnknownNameId(this.getBagItem().getNameId());
        }
        return name;
    }

    public String getName() {
        if (this.isType()) {
            return null;
        }
        ResourceEntry resourceEntry = this.getBagItem().resolveName();
        if (resourceEntry != null) {
            return resourceEntry.getName();
        }
        return null;
    }

    public ResValueMap getBagItem() {
        return this.mBagItem;
    }

    public AttributeType getType() {
        return this.getBagItem().getAttributeType();
    }

    public boolean isFormats() {
        return this.getType() == AttributeType.FORMATS;
    }

    public boolean isType() {
        return this.getType() != null;
    }

    public boolean contains(AttributeDataFormat dataFormat) {
        if (dataFormat == null || !this.isFormats()) {
            return false;
        }
        return dataFormat.matches(this.getBagItem().getData());
    }

    public boolean isEqualType(AttributeDataFormat typeFormat) {
        if (typeFormat == null || !this.isFormats()) {
            return false;
        }
        return typeFormat.getMask() == this.getBagItem().getData();
    }

    public AttributeDataFormat[] getDataFormats() {
        if (!this.isFormats()) {
            return null;
        }
        return AttributeDataFormat.decodeValueTypes(this.getBagItem().getData());
    }

    public boolean isEnum() {
        if (!this.isFormats()) {
            return false;
        }
        return AttributeDataFormat.ENUM.matches(this.getBagItem().getData());
    }

    public boolean isFlag() {
        if (!this.isFormats()) {
            return false;
        }
        return AttributeDataFormat.FLAG.matches(this.getBagItem().getData());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        ResValueMap item = this.getBagItem();
        builder.append(this.getNameOrHex());
        builder.append("=").append(HexUtil.toHex8(item.getData()));
        return builder.toString();
    }

    public static String toString(AttributeBagItem[] bagItems) {
        return AttributeBagItem.toString(bagItems, false);
    }

    public static String toString(AttributeBagItem[] bagItems, boolean use_hex) {
        if (bagItems == null) {
            return null;
        }
        int len = bagItems.length;
        if (len == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean appendOnce = false;
        for (int i = 0; i < len; ++i) {
            String name;
            AttributeBagItem item = bagItems[i];
            if (item == null) continue;
            if (appendOnce) {
                builder.append("|");
            }
            if ((name = use_hex ? item.getNameOrHex() : item.getName()) == null) {
                return null;
            }
            builder.append(name);
            appendOnce = true;
        }
        if (appendOnce) {
            return builder.toString();
        }
        return null;
    }

    public static AttributeBagItem[] create(List<ResValueMap> resValueMaps) {
        if (resValueMaps == null) {
            return null;
        }
        AttributeBagItem format = null;
        int size = resValueMaps.size();
        AttributeBagItem[] bagItems = new AttributeBagItem[size];
        for (int i = 0; i < size; ++i) {
            AttributeBagItem item;
            bagItems[i] = item = new AttributeBagItem(resValueMaps.get(i));
            if (format != null || AttributeType.FORMATS != item.getType()) continue;
            format = item;
        }
        if (format != null) {
            return bagItems;
        }
        return null;
    }
}

