/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ValueHeader;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.HexUtil;

public class EntryHeaderMap
extends ValueHeader {
    private static final short HEADER_SIZE_COMPLEX = 16;
    private static final int OFFSET_PARENT_ID = 8;
    private static final int OFFSET_VALUE_COUNT = 12;
    public static final String NAME_parent_id = "parent_id";

    public EntryHeaderMap() {
        super(16);
        this.setComplex(true);
    }

    public ResourceEntry resolveParentId() {
        Entry parentEntry = this.getParentInstance(Entry.class);
        if (parentEntry != null) {
            return parentEntry.resolve(this.getParentId());
        }
        return null;
    }

    public int getParentId() {
        return EntryHeaderMap.getInteger(this.getBytesInternal(), 8);
    }

    public void setParentId(int parentId) {
        EntryHeaderMap.putInteger(this.getBytesInternal(), 8, parentId);
    }

    public int getValuesCount() {
        return EntryHeaderMap.getInteger(this.getBytesInternal(), 12);
    }

    public void setValuesCount(int valuesCount) {
        EntryHeaderMap.putInteger(this.getBytesInternal(), 12, valuesCount);
    }

    @Override
    public void merge(ValueHeader valueHeader) {
        if (valueHeader == this || !(valueHeader instanceof EntryHeaderMap)) {
            return;
        }
        super.merge(valueHeader);
        EntryHeaderMap entryHeaderMap = (EntryHeaderMap)valueHeader;
        this.setParentId(entryHeaderMap.getParentId());
        this.setValuesCount(entryHeaderMap.getValuesCount());
    }

    @Override
    public void mergeWithName(ResourceMergeOption mergeOption, ValueHeader valueHeader) {
        if (valueHeader == this || !(valueHeader instanceof EntryHeaderMap)) {
            return;
        }
        super.merge(valueHeader);
        EntryHeaderMap entryHeaderMap = (EntryHeaderMap)valueHeader;
        this.setValuesCount(entryHeaderMap.getValuesCount());
        ResourceEntry parentId = entryHeaderMap.resolveParentId();
        if (parentId == null) {
            this.setParentId(entryHeaderMap.getParentId());
        } else {
            int id = 0;
            if (parentId.isContext(entryHeaderMap)) {
                PackageBlock packageBlock = this.getParentInstance(PackageBlock.class);
                parentId = packageBlock.mergeWithName(mergeOption, parentId);
                if (parentId != null) {
                    id = parentId.getResourceId();
                }
            } else {
                id = parentId.getResourceId();
            }
            this.setParentId(id);
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("is_complex", true);
        int parent_id = this.getParentId();
        if (parent_id != 0) {
            jsonObject.put(NAME_parent_id, parent_id);
        }
    }

    @Override
    public void fromJson(JSONObject json) {
        super.fromJson(json);
        this.setComplex(json.optBoolean("is_complex", true));
        this.setParentId(json.optInt(NAME_parent_id));
    }

    @Override
    public String toString() {
        String name;
        if (this.isNull()) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        int byte_size = this.getSize();
        int read_size = this.readSize();
        if (byte_size != 16) {
            builder.append("size=").append(byte_size);
        }
        if (byte_size != read_size) {
            builder.append(", readSize=").append(read_size);
        }
        if (this.isComplex()) {
            builder.append(" complex");
        }
        if (this.isPublic()) {
            builder.append(", public");
        }
        if (this.isWeak()) {
            builder.append(", weak");
        }
        if ((name = this.getName()) != null) {
            builder.append(", name=").append(name);
        } else {
            builder.append(", key=").append(this.getKey());
        }
        int parentId = this.getParentId();
        if (parentId != 0) {
            builder.append(", parentId=");
            builder.append(HexUtil.toHex8(this.getParentId()));
        }
        builder.append(", count=").append(this.getValuesCount());
        return builder.toString();
    }
}

