/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.SpecBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.SpecFlag;
import com.reandroid.arsc.item.SpecString;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.list.EntryItemList;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.model.ResourceName;
import com.reandroid.arsc.pool.SpecStringPool;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.arsc.value.CompoundEntry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.arsc.value.ResTableEntry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.TableEntry;
import com.reandroid.arsc.value.ValueHeader;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.graphics.AndroidColor;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.xml.StyleDocument;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public class Entry
extends Block
implements JSONConvert<JSONObject> {
    private TableEntry<?, ?> mTableEntry;
    private IntegerItem mNullSpecReference;
    public static final Creator<Entry> CREATOR = Entry::new;
    public static final String NAME_id = "id";

    public Iterator<ValueItem> allValues() {
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        if (tableEntry != null) {
            return tableEntry.allValues();
        }
        return EmptyIterator.of();
    }

    public void linkTableStringsInternal(TableStringPool tableStringPool) {
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        tableEntry.linkTableStringsInternal(tableStringPool);
    }

    public void linkSpecStringsInternal(SpecStringPool specStringPool) {
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        Object header = tableEntry.getHeader();
        ((ValueHeader)header).linkSpecStringsInternal(specStringPool);
    }

    public ResValue getResValue() {
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        if (tableEntry instanceof ResTableEntry) {
            return (ResValue)((ResTableEntry)tableEntry).getValue();
        }
        return null;
    }

    public ResValueMapArray getResValueMapArray() {
        ResTableMapEntry resTableMapEntry = this.getResTableMapEntry();
        if (resTableMapEntry != null) {
            return (ResValueMapArray)resTableMapEntry.getValue();
        }
        return null;
    }

    public ResTableMapEntry getResTableMapEntry() {
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        if (tableEntry instanceof ResTableMapEntry) {
            return (ResTableMapEntry)tableEntry;
        }
        return null;
    }

    public String getXmlTag() {
        String tag = TypeString.toXmlTagName(this.getTypeName());
        if (tag == null || !tag.contains("array")) {
            return tag;
        }
        ResTableMapEntry mapEntry = this.getResTableMapEntry();
        if (mapEntry == null) {
            return tag;
        }
        ValueType allValueType = mapEntry.isAllSameValueType();
        if (allValueType == null) {
            return tag;
        }
        if (allValueType == ValueType.STRING) {
            return "string-" + tag;
        }
        if (allValueType == ValueType.DEC) {
            return "integer-" + tag;
        }
        return tag;
    }

    public SpecFlag getSpecFlag() {
        SpecBlock specBlock = this.getSpecBlock();
        if (specBlock == null) {
            return null;
        }
        return specBlock.getSpecFlag(this.getId());
    }

    public void ensureComplex(boolean isComplex) {
        this.ensureTableEntry(isComplex);
    }

    public int getId() {
        int id = this.getIndex();
        EntryItemList entryArray = this.getParentInstance(EntryItemList.class);
        if (entryArray != null) {
            id = entryArray.getEntryId(id);
        }
        return id;
    }

    public SpecString reName(String name) {
        SpecTypePair specTypePair = this.getSpecTypePair();
        if (specTypePair == null) {
            return null;
        }
        SpecString specString = null;
        Iterator<Entry> iterator = specTypePair.getEntries(this.getId(), false);
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (specString == null) {
                specString = entry.setName(name);
                continue;
            }
            entry.updateSpecReference(specString);
        }
        return specString;
    }

    public SpecString setName(String name) {
        return this.setName(name, false);
    }

    public SpecString setName(String name, boolean holdIfNull) {
        int ref;
        if (name == null) {
            this.unlinkNullSpecString();
            TableEntry<?, ?> tableEntry = this.getTableEntry();
            if (tableEntry != null) {
                ((ValueHeader)tableEntry.getHeader()).setKey(null);
            }
            return null;
        }
        if (!holdIfNull && this.isNull()) {
            return null;
        }
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            return null;
        }
        SpecStringPool specStringPool = packageBlock.getSpecStringPool();
        SpecString specString = (SpecString)specStringPool.get(ref = this.getSpecReference());
        if (specString != null && name.equals(specString.get())) {
            return null;
        }
        specString = (SpecString)specStringPool.getOrCreate(name);
        this.setSpecReference(specString);
        return specString;
    }

    public String getName() {
        SpecString specString = this.getSpecString();
        if (specString != null) {
            return specString.get();
        }
        return null;
    }

    public String getTypeName() {
        TypeBlock typeBlock = this.getTypeBlock();
        if (typeBlock != null) {
            return typeBlock.getTypeName();
        }
        return null;
    }

    public int getTypeId() {
        TypeBlock typeBlock = this.getTypeBlock();
        if (typeBlock != null) {
            return typeBlock.getId();
        }
        return 0;
    }

    public int getResourceId() {
        TypeBlock typeBlock = this.getTypeBlock();
        if (typeBlock == null) {
            return 0;
        }
        PackageBlock packageBlock = typeBlock.getPackageBlock();
        if (packageBlock == null) {
            return 0;
        }
        return packageBlock.getId() << 24 | typeBlock.getId() << 16 | this.getId();
    }

    public int getSpecReference() {
        IntegerItem nullReference = this.mNullSpecReference;
        if (nullReference != null) {
            return nullReference.get();
        }
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        if (tableEntry != null) {
            return ((ValueHeader)tableEntry.getHeader()).getKey();
        }
        return -1;
    }

    public TypeString getTypeString() {
        TypeBlock typeBlock = this.getTypeBlock();
        if (typeBlock != null) {
            return typeBlock.getTypeString();
        }
        return null;
    }

    public boolean isDefined() {
        return this.getSpecReference() != -1;
    }

    public boolean isDefault() {
        ResConfig resConfig = this.getResConfig();
        if (resConfig != null) {
            return resConfig.isDefault();
        }
        return false;
    }

    public void setSpecReference(SpecString specString) {
        if (this.isSameSpecString(specString)) {
            return;
        }
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        if (tableEntry != null) {
            ((ValueHeader)tableEntry.getHeader()).setKey(specString);
            this.unlinkNullSpecString();
            return;
        }
        this.linkNullSpecString(specString);
    }

    public void updateSpecReference(SpecString specString) {
        if (this.isSameSpecString(specString)) {
            return;
        }
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        if (tableEntry != null) {
            ((ValueHeader)tableEntry.getHeader()).setKey(specString);
            this.unlinkNullSpecString();
        } else if (this.mNullSpecReference != null) {
            this.linkNullSpecString(specString);
        } else if (specString == null) {
            this.unlinkNullSpecString();
        }
    }

    public void setSpecReference(int ref) {
        if (ref == this.getSpecReference()) {
            return;
        }
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        if (tableEntry == null) {
            this.linkNullSpecString(ref);
            return;
        }
        this.unlinkNullSpecString();
        ((ValueHeader)tableEntry.getHeader()).setKey(ref);
    }

    private boolean isSameSpecString(SpecString specString) {
        int ref = this.getSpecReference();
        if (specString == null) {
            return ref < 0;
        }
        if (ref != specString.getIndex()) {
            return false;
        }
        return this.mNullSpecReference == null || this.getTableEntry() == null;
    }

    private void linkNullSpecString(int ref) {
        if (ref < 0) {
            this.unlinkNullSpecString();
            return;
        }
        SpecStringPool specStringPool = this.getSpecStringPool();
        if (specStringPool == null) {
            this.unlinkNullSpecString();
            return;
        }
        this.linkNullSpecString((SpecString)specStringPool.get(ref));
    }

    private void linkNullSpecString(SpecString specString) {
        if (specString == null) {
            this.unlinkNullSpecString();
            return;
        }
        IntegerItem nullReference = this.mNullSpecReference;
        if (nullReference != null && nullReference.get() == specString.getIndex()) {
            return;
        }
        this.unlinkNullSpecString();
        nullReference = new IntegerItem();
        nullReference.setParent(this);
        nullReference.setIndex(1);
        nullReference.set(specString.getIndex());
        specString.addReference(nullReference);
        this.mNullSpecReference = nullReference;
    }

    private void unlinkNullSpecString() {
        IntegerItem nullReference = this.mNullSpecReference;
        if (nullReference == null) {
            return;
        }
        SpecStringPool specStringPool = this.getSpecStringPool();
        if (specStringPool != null) {
            specStringPool.removeReference(nullReference);
        }
        nullReference.setParent(null);
        nullReference.setIndex(-1);
        this.mNullSpecReference = null;
    }

    private SpecStringPool getSpecStringPool() {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock != null) {
            return packageBlock.getSpecStringPool();
        }
        return null;
    }

    public ValueType getValueType() {
        ResValue resValue = this.getResValue();
        if (resValue != null) {
            return resValue.getValueType();
        }
        return null;
    }

    public String getValueAsString() {
        ResValue resValue = this.getResValue();
        if (resValue != null) {
            return resValue.getValueAsString();
        }
        return null;
    }

    public StyleDocument getValueAsStyleDocument() {
        ResValue resValue = this.getResValue();
        if (resValue != null) {
            return resValue.getValueAsStyleDocument();
        }
        return null;
    }

    public Boolean getValueAsBoolean() {
        ResValue resValue = this.getResValue();
        if (resValue != null) {
            return resValue.getValueAsBoolean();
        }
        return null;
    }

    public AndroidColor getValueAsColor() {
        ResValue resValue = this.getResValue();
        if (resValue != null) {
            return resValue.getValueAsColor();
        }
        return null;
    }

    public Float getValueAsFloat() {
        ResValue resValue = this.getResValue();
        if (resValue != null) {
            return resValue.getValueAsFloat();
        }
        return null;
    }

    public Integer getValueAsInteger() {
        ResValue resValue = this.getResValue();
        if (resValue != null) {
            return resValue.getValueAsInteger();
        }
        return null;
    }

    public ResourceEntry getValueAsReference() {
        ResValue resValue = this.getResValue();
        if (resValue != null) {
            return resValue.getValueAsReference();
        }
        return null;
    }

    public ResValue setValueAsRaw(ValueType valueType, int data) {
        ResValue resValue = this.ensureScalar();
        resValue.setTypeAndData(valueType, data);
        return resValue;
    }

    public ResValue setValueAsBoolean(boolean value) {
        ResValue resValue = this.ensureScalar();
        resValue.setValueAsBoolean(value);
        return resValue;
    }

    public ResValue setValueAsReference(int resourceId) {
        return this.setValueAsRaw(ValueType.REFERENCE, resourceId);
    }

    public ResValue setValueAsString(StyleDocument styledString) {
        TableEntry<?, ?> tableEntry = this.ensureTableEntry(false);
        ResValue resValue = (ResValue)tableEntry.getValue();
        resValue.setValueAsString(styledString);
        return resValue;
    }

    public ResValue setValueAsString(String str) {
        ResValue resValue = this.ensureScalar();
        resValue.setValueAsString(str);
        return resValue;
    }

    public ResValue setValueAsColor(AndroidColor color) {
        ResValue resValue = this.ensureScalar();
        resValue.setValue(color);
        return resValue;
    }

    public SpecString getSpecString() {
        int ref = this.getSpecReference();
        if (ref < 0) {
            return null;
        }
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            return null;
        }
        SpecStringPool specStringPool = packageBlock.getSpecStringPool();
        return (SpecString)specStringPool.get(ref);
    }

    public ResConfig getResConfig() {
        TypeBlock typeBlock = this.getTypeBlock();
        if (typeBlock != null) {
            return typeBlock.getResConfig();
        }
        return null;
    }

    public SpecBlock getSpecBlock() {
        SpecTypePair specTypePair = this.getSpecTypePair();
        if (specTypePair != null) {
            return specTypePair.getSpecBlock();
        }
        return null;
    }

    private SpecTypePair getSpecTypePair() {
        TypeBlock typeBlock = this.getTypeBlock();
        if (typeBlock != null) {
            return typeBlock.getParentSpecTypePair();
        }
        return null;
    }

    public TypeBlock getTypeBlock() {
        return this.getParent(TypeBlock.class);
    }

    private String getPackageName() {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock != null) {
            return packageBlock.getName();
        }
        return null;
    }

    public PackageBlock getPackageBlock() {
        return this.getParent(PackageBlock.class);
    }

    public ResourceEntry getResourceEntry() {
        return new ResourceEntry(this.getPackageBlock(), this.getResourceId());
    }

    public ResourceName getResourceName() {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            return null;
        }
        String name = this.getName();
        if (name == null) {
            return null;
        }
        return new ResourceName(packageBlock.getName(), this.getTypeName(), name);
    }

    private ResValue ensureScalar() {
        return (ResValue)this.ensureTableEntry(false).getValue();
    }

    private TableEntry<?, ?> ensureTableEntry(boolean is_complex) {
        boolean is_correct_type;
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        boolean bl = is_correct_type = is_complex && tableEntry instanceof ResTableMapEntry || !is_complex && tableEntry instanceof ResTableEntry;
        if (tableEntry == null || !is_correct_type) {
            tableEntry = this.createTableEntry(is_complex);
            this.setTableEntry(tableEntry);
        }
        return tableEntry;
    }

    public TableEntry<?, ?> getTableEntry() {
        return this.mTableEntry;
    }

    public ValueHeader getHeader() {
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        if (tableEntry != null) {
            return tableEntry.getHeader();
        }
        return null;
    }

    @Override
    public boolean isNull() {
        return this.getTableEntry() == null;
    }

    @Override
    public void setNull(boolean is_null) {
        if (is_null) {
            this.setTableEntry(null);
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.isNull()) {
            return null;
        }
        return this.getTableEntry().getBytes();
    }

    @Override
    public int countBytes() {
        if (this.isNull()) {
            return 0;
        }
        return this.getTableEntry().countBytes();
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        counter.setCurrent(this);
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        if (this.isNull()) {
            return;
        }
        this.getTableEntry().onCountUpTo(counter);
    }

    @Override
    protected int onWriteBytes(OutputStream stream) throws IOException {
        if (this.isNull()) {
            return 0;
        }
        return this.getTableEntry().writeBytes(stream);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        TableEntry<?, ?> tableEntry = this.createTableEntry(reader);
        this.setTableEntry(tableEntry);
        tableEntry.readBytes(reader);
    }

    public boolean isComplex() {
        return this.getTableEntry() instanceof CompoundEntry;
    }

    public boolean isScalar() {
        return this.getTableEntry() instanceof ResTableEntry;
    }

    public void setTableEntry(TableEntry<?, ?> tableEntry) {
        if (tableEntry == this.mTableEntry) {
            return;
        }
        this.onTableEntryRemoved();
        if (tableEntry == null) {
            return;
        }
        tableEntry.setIndex(0);
        tableEntry.setParent(this);
        this.mTableEntry = tableEntry;
        this.transferSpecReference(tableEntry);
    }

    private void transferSpecReference(TableEntry<?, ?> tableEntry) {
        IntegerItem nullSpecReference = this.mNullSpecReference;
        if (nullSpecReference == null) {
            return;
        }
        int ref = nullSpecReference.get();
        this.unlinkNullSpecString();
        Object valueHeader = tableEntry.getHeader();
        if (((ValueHeader)valueHeader).getKey() < 0) {
            ((ValueHeader)valueHeader).setKey(ref);
        }
    }

    private void onTableEntryRemoved() {
        TableEntry<?, ?> exist = this.mTableEntry;
        if (exist == null) {
            return;
        }
        exist.onRemoved();
        exist.setIndex(-1);
        exist.setParent(null);
        this.mTableEntry = null;
    }

    private TableEntry<?, ?> createTableEntry(BlockReader reader) throws IOException {
        int startPosition = reader.getPosition();
        reader.offset(2);
        boolean is_complex = (1 & reader.readShort()) == 1;
        reader.seek(startPosition);
        return this.createTableEntry(is_complex);
    }

    private TableEntry<?, ?> createTableEntry(boolean is_complex) {
        if (is_complex) {
            return new ResTableMapEntry();
        }
        return new ResTableEntry();
    }

    @Override
    public JSONObject toJson() {
        if (!this.isNull()) {
            return this.getTableEntry().toJson();
        }
        return null;
    }

    @Override
    public void fromJson(JSONObject json) {
        if (json == null) {
            this.setNull(true);
            return;
        }
        boolean is_complex = json.optBoolean("is_complex", false);
        TableEntry<?, ?> entry = this.createTableEntry(is_complex);
        this.setTableEntry(entry);
        entry.fromJson(json);
    }

    public ResourceEntry resolve(int resourceId) {
        PackageBlock packageBlock = this.getPackageBlock();
        return packageBlock.getTableBlock().getResource(packageBlock, resourceId);
    }

    public void merge(Entry entry) {
        if (this.canMerge(entry)) {
            TableEntry<?, ?> tableEntry = entry.getTableEntry();
            TableEntry<?, ?> existEntry = this.ensureTableEntry(tableEntry instanceof ResTableMapEntry);
            existEntry.merge(tableEntry);
        }
    }

    public void mergeWithName(ResourceMergeOption mergeOption, Entry entry) {
        if (this.canMerge(entry)) {
            this.unlinkNullSpecString();
            TableEntry<?, ?> tableEntry = entry.getTableEntry();
            TableEntry<?, ?> existEntry = this.ensureTableEntry(tableEntry instanceof ResTableMapEntry);
            existEntry.mergeWithName(mergeOption, tableEntry);
        }
    }

    private boolean canMerge(Entry coming) {
        if (coming == null || coming == this || coming.isNull()) {
            return false;
        }
        if (this.isNull()) {
            return true;
        }
        return this.getTableEntry().canMerge(coming.getTableEntry());
    }

    public String toString() {
        SpecFlag specFlag;
        StringBuilder builder = new StringBuilder();
        builder.append(HexUtil.toHex8(this.getResourceId()));
        builder.append(' ');
        ResConfig resConfig = this.getResConfig();
        if (resConfig != null) {
            builder.append(resConfig);
            builder.append(' ');
        }
        if ((specFlag = this.getSpecFlag()) != null) {
            builder.append(specFlag);
            builder.append(' ');
        }
        if (this.isNull()) {
            builder.append("NULL ");
        }
        builder.append('@');
        builder.append(this.getTypeName());
        builder.append('/');
        builder.append(this.getName());
        return builder.toString();
    }
}

