/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.model;

import android.content.res.XmlResourceParser;
import com.reandroid.arsc.ApkFile;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.ResXmlPullParser;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.model.ResourcePackage;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;

public class ResourceTable
implements Iterable<ResourcePackage> {
    private final TableBlock tableBlock;

    public ResourceTable(TableBlock tableBlock) {
        this.tableBlock = tableBlock;
    }

    public XmlResourceParser getLayout(int resourceId) throws IOException {
        return this.getParser(resourceId);
    }

    public XmlResourceParser getXml(int resourceId) throws IOException {
        return this.getParser(resourceId);
    }

    public XmlResourceParser getParser(int resourceId) throws IOException {
        ApkFile apkFile = this.getApkFile();
        if (apkFile == null) {
            throw new FileNotFoundException("Missing apk file");
        }
        Iterator<String> iterator = this.getStrings(resourceId);
        while (iterator.hasNext()) {
            String path = iterator.next();
            if (!apkFile.containsFile(path)) continue;
            return this.loadXml(path);
        }
        throw new FileNotFoundException("No resource found for: " + HexUtil.toHex8(resourceId));
    }

    public Iterator<XmlResourceParser> getParsers(int resourceId) {
        return ComputeIterator.of(this.getStrings(resourceId), path -> {
            try {
                return this.loadXml((String)path);
            }
            catch (IOException ignored) {
                return null;
            }
        });
    }

    XmlResourceParser loadXml(String path) throws IOException {
        ApkFile apkFile = this.getApkFile();
        if (apkFile == null || !apkFile.containsFile(path)) {
            throw new FileNotFoundException("Missing apk file");
        }
        return new ResXmlPullParser(apkFile.loadResXmlDocument(path));
    }

    public String getString(int resourceId) {
        Iterator<String> iterator = this.getStrings(resourceId);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public Iterator<String> getStrings(int resourceId) {
        ResourceEntry resourceEntry = this.getResource(resourceId);
        if (resourceEntry != null) {
            return resourceEntry.getStringValues();
        }
        return EmptyIterator.of();
    }

    public int getIdentifier(String name, String type, String packageName) {
        ResourceEntry resourceEntry = this.getResource(packageName, type, name);
        if (resourceEntry != null) {
            return resourceEntry.getResourceId();
        }
        return 0;
    }

    public ResourceEntry getResource(String name, String type, String packageName) {
        return this.getTableBlock().getResource(packageName, type, name);
    }

    public ResourceEntry getResource(int resourceId) {
        return this.getTableBlock().getResource(resourceId);
    }

    @Override
    public Iterator<ResourcePackage> iterator() {
        return ComputeIterator.of(this.getTableBlock().iterator(), ResourcePackage::new);
    }

    public int size() {
        return this.getTableBlock().size();
    }

    private ApkFile getApkFile() {
        return this.getTableBlock().getApkFile();
    }

    public TableBlock getTableBlock() {
        return this.tableBlock;
    }

    public int hashCode() {
        return this.getTableBlock().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceTable)) {
            return false;
        }
        ResourceTable table = (ResourceTable)obj;
        if (this.size() != table.size()) {
            return false;
        }
        Iterator<ResourcePackage> iterator = this.iterator();
        Iterator<ResourcePackage> others = table.iterator();
        while (iterator.hasNext() && others.hasNext()) {
            if (iterator.next().equals(others.next())) continue;
            return false;
        }
        return !iterator.hasNext() && others.hasNext();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("packages = ");
        builder.append(this.size());
        builder.append('[');
        boolean append = false;
        for (ResourcePackage resourcePackage : this) {
            if (append) {
                builder.append(", ");
            }
            builder.append(resourcePackage.getName());
            append = true;
        }
        builder.append(']');
        return builder.toString();
    }
}

