/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.list;

import com.reandroid.arsc.chunk.Overlayable;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class OverlayableList
extends BlockList<Overlayable>
implements Iterable<Overlayable>,
JSONConvert<JSONArray> {
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Overlayable get(String name) {
        for (Overlayable overlayable : this) {
            if (!ObjectsUtil.equals(name, overlayable.getName())) continue;
            return overlayable;
        }
        return null;
    }

    public Overlayable get(String name, String actor) {
        for (Overlayable overlayable : this) {
            if (!ObjectsUtil.equals(name, overlayable.getName()) && !ObjectsUtil.equals(actor, overlayable.getActor())) continue;
            return overlayable;
        }
        return null;
    }

    @Override
    public Overlayable createNext() {
        Overlayable overlayable = new Overlayable();
        this.add(overlayable);
        return overlayable;
    }

    public void parse(XmlPullParser parser) throws IOException, XmlPullParserException {
        if (parser.getEventType() == 0) {
            parser.next();
        }
        XMLUtil.ensureStartTag(parser);
        if (PackageBlock.TAG_resources.equals(parser.getName())) {
            parser.next();
            XMLUtil.ensureStartTag(parser);
        }
        while (parser.getEventType() != 3 && parser.getEventType() != 1) {
            Overlayable overlayable = this.createNext();
            overlayable.parse(parser);
            XMLUtil.ensureTag(parser);
        }
        if (parser.getEventType() == 3) {
            parser.next();
            XMLUtil.ensureTag(parser);
        }
        if (parser.getEventType() == 3 && PackageBlock.TAG_resources.equals(parser.getName())) {
            parser.next();
            XMLUtil.ensureTag(parser);
        }
    }

    public void serialize(XmlSerializer serializer) throws IOException {
        serializer.startDocument("utf-8", null);
        serializer.startTag(null, PackageBlock.TAG_resources);
        for (Overlayable overlayable : this) {
            overlayable.serialize(serializer);
        }
        serializer.endTag(null, PackageBlock.TAG_resources);
        serializer.endDocument();
    }

    @Override
    public JSONArray toJson() {
        if (this.isEmpty()) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (Overlayable overlayable : this) {
            jsonArray.put(overlayable.toJson());
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        if (json == null) {
            return;
        }
        int length = json.length();
        for (int i = 0; i < length; ++i) {
            this.createNext().fromJson(json.getJSONObject(i));
        }
    }

    public void merge(OverlayableList overlayableList) {
        if (overlayableList == null || overlayableList == this) {
            return;
        }
        for (Overlayable overlayable : overlayableList) {
            Overlayable exist = this.get(overlayable.getName(), overlayable.getActor());
            if (exist == null) {
                exist = this.get(overlayable.getName());
            }
            if (exist == null) {
                exist = this.createNext();
            }
            exist.merge(overlayable);
        }
    }
}

