/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.base.DirectStreamReader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;

public abstract class OffsetItem
extends BlockItem
implements DirectStreamReader,
Comparable<OffsetItem> {
    public static int NO_ENTRY = ObjectsUtil.of(-1);
    public static int NO_ENTRY16 = ObjectsUtil.of(65535);
    public static final Creator<OffsetItem> CREATOR_OFFSET16 = Helper.init16();
    public static final Creator<OffsetItem> CREATOR_OFFSET32 = Helper.init32();
    public static final Creator<OffsetItem> CREATOR_SPARSE = Helper.initSparse();
    private int mOffset;

    protected OffsetItem(int bytesLength) {
        super(bytesLength);
    }

    protected OffsetItem() {
        this(4);
    }

    public int getOffset() {
        return this.mOffset;
    }

    public void setOffset(int offset) {
        if (offset != this.mOffset) {
            this.writeOffset(offset);
            this.mOffset = offset;
        }
    }

    public int getIdx() {
        return this.getIndex();
    }

    public void setIdx(int idx) {
    }

    protected abstract int readOffset();

    protected abstract void writeOffset(int var1);

    @Override
    protected void onBytesChanged() {
        super.onBytesChanged();
        this.mOffset = this.readOffset();
    }

    public boolean isNoEntry() {
        return this.getOffset() == NO_ENTRY;
    }

    public int updateOffset(Block target, int offset) {
        if (target.isNull()) {
            this.setOffset(NO_ENTRY);
        } else {
            this.setOffset(offset);
            offset += target.countBytes();
        }
        return offset;
    }

    public void readTarget(BlockReader reader, Block target) throws IOException {
        this.readTarget(reader, target, false);
    }

    public void readTarget(BlockReader reader, Block target, boolean ignoreOutOfRange) throws IOException {
        boolean noEntry = this.isNoEntry();
        int offset = this.getOffset();
        if (!noEntry) {
            int maximumPosition = reader.getPosition() + reader.available();
            if (offset < 0 || offset > maximumPosition) {
                if (!ignoreOutOfRange) {
                    throw new IOException("Offset " + offset + " is out of range " + maximumPosition);
                }
                offset = NO_ENTRY;
                this.setOffset(offset);
                noEntry = true;
            }
        }
        target.setNull(noEntry);
        if (!noEntry) {
            int position = reader.getPosition();
            reader.seek(offset);
            try {
                target.readBytes(reader);
            }
            catch (Exception ex) {
                throw new IOException("Error at:" + this.toString() + ex.getMessage(), ex);
            }
            int current = reader.getPosition();
            if (current < position) {
                reader.seek(position);
            }
        }
    }

    protected void validateValueRange(int value) {
        if (value != NO_ENTRY && (value & 0xFFFF0000) != 0) {
            throw new NumberFormatException("Value out of range [0 - 0xffff]: " + HexUtil.toHex(value, 1));
        }
    }

    public int compareOffset(OffsetItem offsetItem) {
        if (offsetItem == this) {
            return 0;
        }
        return CompareUtil.compare(this.getOffset(), offsetItem.getOffset());
    }

    public int compareIdx(OffsetItem offsetItem) {
        if (offsetItem == this) {
            return 0;
        }
        return CompareUtil.compare(this.getIdx(), offsetItem.getIdx());
    }

    @Override
    public int compareTo(OffsetItem offsetItem) {
        return this.compareIdx(offsetItem);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        builder.append(this.getIdx());
        builder.append(", ");
        if (this.isNoEntry()) {
            builder.append("NO_ENTRY");
        } else {
            builder.append(this.getOffset());
        }
        builder.append(')');
        return builder.toString();
    }

    static class Helper {
        Helper() {
        }

        static Creator<OffsetItem> init16() {
            return Offset16::new;
        }

        static Creator<OffsetItem> init32() {
            return Offset32::new;
        }

        static Creator<OffsetItem> initSparse() {
            return Sparse::new;
        }
    }

    static class Sparse
    extends OffsetItem {
        private int mIdx;

        @Override
        public int getIdx() {
            return this.mIdx;
        }

        @Override
        public void setIdx(int idx) {
            if (idx != this.mIdx) {
                this.validateValueRange(idx);
                this.mIdx = idx;
                Sparse.putShort(this.getBytesInternal(), 0, idx);
            }
        }

        @Override
        public boolean isNoEntry() {
            return false;
        }

        @Override
        protected void onBytesChanged() {
            super.onBytesChanged();
            this.mIdx = Sparse.getShortUnsigned(this.getBytesInternal(), 0);
        }

        @Override
        protected int readOffset() {
            return Sparse.getShortUnsigned(this.getBytesInternal(), 2) * 4;
        }

        @Override
        protected void writeOffset(int offset) {
            int value = offset / 4;
            this.validateValueRange(value);
            Sparse.putShort(this.getBytesInternal(), 2, value);
        }

        @Override
        public int compareTo(OffsetItem offsetItem) {
            return this.compareOffset(offsetItem);
        }
    }

    static class Offset32
    extends OffsetItem {
        @Override
        protected int readOffset() {
            return Offset32.getInteger(this.getBytesInternal(), 0);
        }

        @Override
        protected void writeOffset(int offset) {
            Offset32.putInteger(this.getBytesInternal(), 0, offset);
        }

        @Override
        public int compareTo(OffsetItem offsetItem) {
            return this.compareIdx(offsetItem);
        }
    }

    static class Offset16
    extends OffsetItem {
        public Offset16() {
            super(2);
        }

        @Override
        protected int readOffset() {
            int offset = Offset16.getShortUnsigned(this.getBytesInternal(), 0);
            offset = offset == NO_ENTRY16 ? NO_ENTRY : (offset *= 4);
            return offset;
        }

        @Override
        protected void writeOffset(int offset) {
            if (offset == NO_ENTRY) {
                offset = NO_ENTRY16;
            } else {
                this.validateValueRange(offset /= 4);
            }
            Offset16.putShort(this.getBytesInternal(), 0, offset);
        }

        @Override
        public int compareTo(OffsetItem offsetItem) {
            return this.compareIdx(offsetItem);
        }
    }
}

