/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.container;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.base.DirectStreamReader;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import java.io.IOException;
import java.io.InputStream;

public class CountedBlockList<T extends Block>
extends BlockList<T>
implements DirectStreamReader {
    private final IntegerReference countReference;

    public CountedBlockList(Creator<? extends T> creator, IntegerReference countReference) {
        super(creator);
        this.countReference = countReference;
    }

    public IntegerReference getCountReference() {
        return this.countReference;
    }

    @Override
    protected void onRefreshed() {
        this.updateCountReference();
        super.onRefreshed();
    }

    protected void updateCountReference() {
        this.getCountReference().set(this.size());
    }

    @Override
    protected void onReadBytes(BlockReader reader) throws IOException {
        this.setSize(this.getCountReference().get());
        this.readChildes(reader);
    }

    @Override
    public int readBytes(InputStream inputStream) throws IOException, ClassCastException {
        int size = this.getCountReference().get();
        this.setSize(size);
        int result = 0;
        for (int i = 0; i < size; ++i) {
            result += ((DirectStreamReader)this.get(i)).readBytes(inputStream);
        }
        return result;
    }
}

