/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder.xml;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.coder.xml.ValuesSerializerFactory;
import com.reandroid.arsc.coder.xml.XmlDecodeUtil;
import com.reandroid.utils.io.FileUtil;
import com.reandroid.utils.io.IOUtil;
import com.reandroid.xml.XMLFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlSerializer;

public class ValuesDirectorySerializer
implements ValuesSerializerFactory {
    private final File resourcesDir;
    private final Map<XmlSerializer, File> serializerFileMap;

    public ValuesDirectorySerializer(File resourcesDir) {
        this.resourcesDir = resourcesDir;
        this.serializerFileMap = new HashMap<XmlSerializer, File>();
    }

    @Override
    public void onFinish(XmlSerializer serializer, int writtenEntries) throws IOException {
        XmlDecodeUtil.rootIndent(serializer);
        serializer.endTag(null, PackageBlock.TAG_resources);
        serializer.endDocument();
        serializer.flush();
        IOUtil.close(serializer);
        File file = this.serializerFileMap.remove(serializer);
        if (writtenEntries == 0 && file != null && file.isFile()) {
            file.delete();
            File dir = file.getParentFile();
            FileUtil.deleteEmptyDirectory(dir);
        }
    }

    @Override
    public XmlSerializer createSerializer(TypeBlock typeBlock) throws IOException {
        File dir = new File(this.resourcesDir, typeBlock.getPackageBlock().buildDecodeDirectoryName());
        dir = new File(dir, "res");
        dir = new File(dir, "values" + typeBlock.getResConfig().getQualifiers());
        String name = typeBlock.getTypeName();
        if (!name.endsWith("s")) {
            name = name + "s";
        }
        name = name + ".xml";
        File file = new File(dir, name);
        XmlSerializer serializer = XMLFactory.newSerializer(file);
        this.serializerFileMap.put(serializer, file);
        serializer.startDocument("utf-8", null);
        XmlDecodeUtil.rootIndent(serializer);
        serializer.startTag(null, PackageBlock.TAG_resources);
        return serializer;
    }
}

