/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.arsc.value.ValueType;
import com.reandroid.utils.HexUtil;
import java.util.Objects;

public class EncodeResult {
    public final ValueType valueType;
    public final int value;
    private final String error;
    public static final EncodeResult RESOURCE_NOT_FOUND = new EncodeResult("RESOURCE NOT FOUND");

    public EncodeResult(ValueType valueType, int value, String error) {
        this.valueType = valueType;
        this.value = value;
        this.error = error;
    }

    public EncodeResult(ValueType valueType, int value) {
        this(valueType, value, null);
    }

    public EncodeResult(String error) {
        this(ValueType.NULL, -1, error);
    }

    public String getError() {
        return this.error;
    }

    public boolean isError() {
        return this.getError() != null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EncodeResult other = (EncodeResult)obj;
        String error = this.getError();
        if (error != null) {
            return error.equals(other.getError());
        }
        if (other.getError() != null) {
            return false;
        }
        return this.value == other.value && this.valueType == other.valueType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.valueType, this.value, this.getError()});
    }

    public String toString() {
        String error = this.getError();
        if (error != null) {
            return error;
        }
        return (Object)((Object)this.valueType) + ": " + HexUtil.toHex8(this.value);
    }
}

