/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.BaseXmlChunk;
import com.reandroid.arsc.chunk.xml.ResXmlEndElement;
import com.reandroid.arsc.chunk.xml.ResXmlEndNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlTextChunk;
import com.reandroid.arsc.chunk.xml.UnknownResXmlNode;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.json.JSONException;
import com.reandroid.json.JSONObject;

public class UnexpectedResXmlNode
extends UnknownResXmlNode {
    public UnexpectedResXmlNode(ChunkType chunkType) {
        super(UnexpectedResXmlNode.of(chunkType));
    }

    @Override
    public int getLineNumber() {
        return this.getBaseXmlChunk().getLineNumber();
    }

    private BaseXmlChunk getBaseXmlChunk() {
        return (BaseXmlChunk)this.getChunk();
    }

    @Override
    void linkStringReferences() {
        this.getBaseXmlChunk().linkStringReferences();
    }

    @Override
    void onPreRemove() {
        this.getBaseXmlChunk().onPreRemove();
    }

    public String getString() {
        BaseXmlChunk chunk = this.getBaseXmlChunk();
        return chunk.getString(chunk.getStringReference());
    }

    public void setString(String value) {
        this.getBaseXmlChunk().setString(value);
    }

    public String getUri() {
        return this.getBaseXmlChunk().getUri();
    }

    public void setUri(String uri) {
        BaseXmlChunk chunk = this.getBaseXmlChunk();
        ResXmlString xmlString = chunk.getOrCreateString(uri);
        int reference = xmlString != null ? xmlString.getIndex() : -1;
        chunk.setNamespaceReference(reference);
    }

    public String getComment() {
        return this.getBaseXmlChunk().getComment();
    }

    public void setComment(String value) {
        this.getBaseXmlChunk().setComment(value);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(JSON_node_type, this.nodeTypeName());
        jsonObject.put(JSON_type, this.getChunkType());
        jsonObject.put(JSON_comment, this.getComment());
        jsonObject.put(JSON_uri, this.getUri());
        jsonObject.put(JSON_value, this.getString());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) throws NumberFormatException {
        if (!this.nodeTypeName().equals(json.optString(JSON_node_type, null))) {
            throw new JSONException("Expecting: " + this.nodeTypeName() + ", but found: " + json.optString(JSON_node_type, null));
        }
        this.setComment(json.optString(JSON_comment, null));
        this.setUri(json.optString(JSON_uri, null));
        this.setString(json.optString(JSON_value, null));
    }

    public static boolean isSet(int chunkType) {
        return UnexpectedResXmlNode.isSet(ChunkType.get((short)chunkType));
    }

    public static boolean isSet(ChunkType chunkType) {
        return chunkType == ChunkType.XML_END_ELEMENT || chunkType == ChunkType.XML_END_NAMESPACE || chunkType == ChunkType.XML_CDATA;
    }

    private static Chunk<?> of(ChunkType chunkType) {
        if (chunkType == ChunkType.XML_END_ELEMENT) {
            return new ResXmlEndElement();
        }
        if (chunkType == ChunkType.XML_END_NAMESPACE) {
            return new ResXmlEndNamespace();
        }
        if (chunkType == ChunkType.XML_CDATA) {
            return new ResXmlTextChunk();
        }
        throw new RuntimeException("Invalid chunk type: " + (Object)((Object)chunkType));
    }
}

