/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlEvent;
import com.reandroid.arsc.chunk.xml.ResXmlNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlNodeTree;
import com.reandroid.arsc.chunk.xml.ResXmlTextNode;
import com.reandroid.arsc.coder.XmlSanitizer;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ResXmlEventParser
implements XmlPullParser {
    private final Iterator<ResXmlEvent> eventIterator;
    private ResXmlEvent mCurrent;
    private boolean mFirstPulled;
    private boolean mFinished;
    private boolean processNamespaces;
    private boolean reportNamespaceAttrs;
    private Object location;

    public ResXmlEventParser(Iterator<ResXmlEvent> eventIterator) {
        this.eventIterator = eventIterator;
        this.processNamespaces = true;
        this.reportNamespaceAttrs = true;
    }

    public ResXmlEvent getCurrent() {
        if (this.mFinished) {
            return null;
        }
        if (!this.mFirstPulled) {
            try {
                this.nextParserEvent();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.mCurrent;
    }

    private void nextParserEvent() throws XmlPullParserException {
        this.mFirstPulled = true;
        if (!this.mFinished && this.eventIterator.hasNext()) {
            this.mCurrent = this.eventIterator.next();
        } else {
            if (this.mFinished) {
                throw new XmlPullParserException("Finished", this, null);
            }
            this.mFinished = true;
        }
    }

    private ResXmlNode getXmlNode() {
        ResXmlEvent event = this.getCurrent();
        if (event != null) {
            return event.getXmlNode();
        }
        return null;
    }

    public ResXmlElement getCurrentElement() {
        ResXmlNode xmlNode = this.getXmlNode();
        if (xmlNode instanceof ResXmlElement) {
            return (ResXmlElement)xmlNode;
        }
        return (ResXmlElement)ObjectsUtil.getNull();
    }

    public ResXmlDocument getDocument() {
        ResXmlNode xmlNode = this.getXmlNode();
        if (xmlNode instanceof ResXmlDocument) {
            return (ResXmlDocument)xmlNode;
        }
        if (xmlNode instanceof ResXmlElement) {
            return ((ResXmlElement)xmlNode).getParentDocument();
        }
        if (xmlNode instanceof ResXmlTextNode) {
            ResXmlNodeTree parent = ((ResXmlTextNode)xmlNode).getParentNode();
            if (parent instanceof ResXmlDocument) {
                return (ResXmlDocument)parent;
            }
            if (parent instanceof ResXmlElement) {
                return ((ResXmlElement)parent).getParentDocument();
            }
        }
        return (ResXmlDocument)ObjectsUtil.getNull();
    }

    private boolean isCountNamespacesAsAttribute() {
        return this.isProcessNamespaces() & this.isReportNamespaceAttrs();
    }

    public boolean isProcessNamespaces() {
        return this.processNamespaces;
    }

    public boolean isReportNamespaceAttrs() {
        return this.reportNamespaceAttrs;
    }

    private int getRealAttributeIndex(int index) {
        if (this.isCountNamespacesAsAttribute()) {
            index -= this.getNamespaceCountInternal();
        }
        return index;
    }

    private int getNamespaceCountInternal() {
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            return element.getNamespaceCount();
        }
        return 0;
    }

    private String getNamespaceAttributeName(int index) {
        ResXmlNamespace namespace = this.getCurrentElement().getNamespaceAt(index);
        return "xmlns:" + namespace.getPrefix();
    }

    private String decodeAttributeName(ResXmlAttribute attribute) {
        if (attribute != null) {
            if (attribute.getPackageBlock() == null) {
                return attribute.getName(this.isProcessNamespaces());
            }
            return attribute.decodeName(this.isProcessNamespaces());
        }
        return null;
    }

    public ResXmlAttribute getResXmlAttributeAt(int index) {
        index = this.getRealAttributeIndex(index);
        ResXmlElement element = this.getCurrentElement();
        if (element == null) {
            return null;
        }
        return element.getAttributeAt(index);
    }

    private String decodeAttributeValue(ResXmlAttribute attribute) {
        if (attribute != null) {
            String value = attribute.decodeValue();
            if (attribute.getValueType() == ValueType.STRING) {
                value = XmlSanitizer.escapeSpecialCharacter(value);
            }
            return value;
        }
        return null;
    }

    public ResXmlAttribute getAttribute(String namespace, String name) {
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            return element.searchAttribute(namespace, name);
        }
        return null;
    }

    private String getNamespaceAttributeValue(int index) {
        ResXmlNamespace namespace = this.getCurrentElement().getNamespaceAt(index);
        return namespace.getUri();
    }

    @Override
    public void setFeature(String name, boolean state) throws XmlPullParserException {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(name)) {
            this.processNamespaces = state;
        } else if ("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes".equals(name)) {
            this.reportNamespaceAttrs = state;
        } else {
            throw new XmlPullParserException("Unsupported feature: " + name);
        }
    }

    @Override
    public boolean getFeature(String name) {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(name)) {
            return this.processNamespaces;
        }
        if ("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes".equals(name)) {
            return this.reportNamespaceAttrs;
        }
        return false;
    }

    @Override
    public void setProperty(String name, Object value) throws XmlPullParserException {
        if (!XMLUtil.PROPERTY_LOCATION.equals(name)) {
            throw new XmlPullParserException("unsupported property: " + name);
        }
        this.location = value;
    }

    @Override
    public Object getProperty(String name) {
        if (XMLUtil.PROPERTY_LOCATION.equals(name)) {
            return this.location;
        }
        return null;
    }

    @Override
    public void setInput(Reader in) throws XmlPullParserException {
    }

    @Override
    public void setInput(InputStream inputStream, String inputEncoding) throws XmlPullParserException {
    }

    @Override
    public String getInputEncoding() {
        ResXmlDocument document = this.getDocument();
        if (document != null) {
            return document.getEncoding();
        }
        return null;
    }

    @Override
    public void defineEntityReplacementText(String entityName, String replacementText) {
    }

    @Override
    public int getNamespaceCount(int depth) throws XmlPullParserException {
        ResXmlElement element;
        if (this.isCountNamespacesAsAttribute()) {
            return 0;
        }
        for (element = this.getCurrentElement(); element != null && element.getDepth() > depth; element = element.getParentElement()) {
        }
        if (element != null) {
            return element.getNamespaceCount();
        }
        return 0;
    }

    @Override
    public String getNamespacePrefix(int pos) throws XmlPullParserException {
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            return element.getNamespaceAt(pos).getPrefix();
        }
        return null;
    }

    @Override
    public String getNamespaceUri(int pos) {
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            return element.getNamespaceAt(pos).getUri();
        }
        return null;
    }

    @Override
    public String getNamespace(String prefix) {
        ResXmlNamespace namespace;
        ResXmlElement element = this.getCurrentElement();
        if (element != null && (namespace = element.getNamespaceForPrefix(prefix)) != null) {
            return namespace.getUri();
        }
        return null;
    }

    @Override
    public int getDepth() {
        ResXmlEvent xmlEvent = this.getCurrent();
        if (xmlEvent != null) {
            return xmlEvent.getDepth();
        }
        return 0;
    }

    @Override
    public String getPositionDescription() {
        StringBuilder builder = new StringBuilder();
        Object location = XMLUtil.getLocation(this);
        if (location != null) {
            builder.append(" at ");
            builder.append(location);
        }
        builder.append(" Binary XML file line #");
        builder.append(this.getLineNumber());
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            if (this.getCurrent().getType() == 2) {
                builder.append(" START_TAG ");
            } else {
                builder.append(" END_TAG ");
            }
            builder.append('<');
            builder.append(element.getName(true));
            builder.append('>');
        }
        return builder.toString();
    }

    @Override
    public int getLineNumber() {
        ResXmlEvent xmlEvent = this.getCurrent();
        if (xmlEvent != null) {
            return xmlEvent.getLineNumber();
        }
        return 0;
    }

    @Override
    public int getColumnNumber() {
        return 0;
    }

    @Override
    public boolean isWhitespace() throws XmlPullParserException {
        ResXmlNode xmlNode = this.getXmlNode();
        if (xmlNode instanceof ResXmlTextNode) {
            return ((ResXmlTextNode)xmlNode).isBlank();
        }
        return false;
    }

    @Override
    public String getText() {
        ResXmlEvent xmlEvent = this.getCurrent();
        if (xmlEvent != null) {
            return xmlEvent.getText();
        }
        return null;
    }

    @Override
    public char[] getTextCharacters(int[] holderForStartAndLength) {
        String text = this.getText();
        if (text == null) {
            holderForStartAndLength[0] = -1;
            holderForStartAndLength[1] = -1;
            return null;
        }
        char[] result = text.toCharArray();
        holderForStartAndLength[0] = 0;
        holderForStartAndLength[1] = result.length;
        return result;
    }

    @Override
    public String getNamespace() {
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            return element.getUri();
        }
        return null;
    }

    @Override
    public String getName() {
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            return element.getName();
        }
        return null;
    }

    @Override
    public String getPrefix() {
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            return element.getPrefix();
        }
        return null;
    }

    @Override
    public boolean isEmptyElementTag() {
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            return element.size() == 0 && element.getAttributeCount() == 0;
        }
        return true;
    }

    @Override
    public int getAttributeCount() {
        int count = 0;
        ResXmlElement element = this.getCurrentElement();
        if (element != null) {
            count = element.getAttributeCount();
            if (this.isCountNamespacesAsAttribute()) {
                count += element.getNamespaceCount();
            }
        }
        return count;
    }

    @Override
    public String getAttributeNamespace(int index) {
        ResXmlAttribute attribute;
        if (!this.isProcessNamespaces() && (attribute = this.getResXmlAttributeAt(index)) != null) {
            return attribute.getUri();
        }
        return null;
    }

    @Override
    public String getAttributeName(int index) {
        int nsCount;
        if (this.isCountNamespacesAsAttribute() && index < (nsCount = this.getNamespaceCountInternal())) {
            return this.getNamespaceAttributeName(index);
        }
        return this.decodeAttributeName(this.getResXmlAttributeAt(index));
    }

    @Override
    public String getAttributePrefix(int index) {
        ResXmlAttribute attribute;
        if (!this.isProcessNamespaces() && (attribute = this.getResXmlAttributeAt(index)) != null) {
            return attribute.getPrefix();
        }
        return null;
    }

    @Override
    public String getAttributeType(int index) {
        return "CDATA";
    }

    @Override
    public boolean isAttributeDefault(int index) {
        return false;
    }

    @Override
    public String getAttributeValue(int index) {
        int nsCount;
        if (this.isCountNamespacesAsAttribute() && index < (nsCount = this.getNamespaceCountInternal())) {
            return this.getNamespaceAttributeValue(index);
        }
        return this.decodeAttributeValue(this.getResXmlAttributeAt(index));
    }

    @Override
    public String getAttributeValue(String namespace, String name) {
        return this.decodeAttributeValue(this.getAttribute(namespace, name));
    }

    @Override
    public int getEventType() throws XmlPullParserException {
        ResXmlEvent resXmlEvent = this.getCurrent();
        if (resXmlEvent != null) {
            return resXmlEvent.getType();
        }
        return -1;
    }

    @Override
    public int next() throws XmlPullParserException, IOException {
        this.nextParserEvent();
        return this.getEventType();
    }

    @Override
    public int nextToken() throws XmlPullParserException, IOException {
        this.nextParserEvent();
        return this.getEventType();
    }

    @Override
    public void require(int type, String namespace, String name) throws XmlPullParserException, IOException {
        if (type != this.getEventType() || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
            throw new XmlPullParserException("expected: " + TYPES[type] + " {" + namespace + "}" + name, this, null);
        }
    }

    @Override
    public String nextText() throws XmlPullParserException, IOException {
        int event = this.getEventType();
        if (event != 2) {
            throw new XmlPullParserException("precondition: START_TAG", this, null);
        }
        while (event != 4 && event != 3 && event != 1) {
            event = this.next();
        }
        if (event == 4) {
            return this.getText();
        }
        return "";
    }

    @Override
    public int nextTag() throws XmlPullParserException, IOException {
        int event = this.getEventType();
        if (event != 2) {
            throw new XmlPullParserException("precondition: START_TAG", this, null);
        }
        event = this.next();
        while (event != 2 && event != 1) {
            event = this.next();
        }
        return event;
    }
}

