/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlTextNode;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import org.xmlpull.v1.XmlPullParser;

public class ResXmlEvent {
    private final int type;
    private final ResXmlNode xmlNode;
    public static final int START_DOCUMENT = ObjectsUtil.of(0);
    public static final int END_DOCUMENT = ObjectsUtil.of(1);
    public static final int START_TAG = ObjectsUtil.of(2);
    public static final int END_TAG = ObjectsUtil.of(3);
    public static final int TEXT = ObjectsUtil.of(4);
    public static final int CDSECT = ObjectsUtil.of(5);
    public static final int ENTITY_REF = ObjectsUtil.of(6);
    public static final int IGNORABLE_WHITESPACE = ObjectsUtil.of(7);
    public static final int PROCESSING_INSTRUCTION = ObjectsUtil.of(8);
    public static final int COMMENT = ObjectsUtil.of(9);
    public static final int DOCDECL = ObjectsUtil.of(10);

    public ResXmlEvent(int type, ResXmlNode xmlNode) {
        this.type = type;
        this.xmlNode = xmlNode;
    }

    public int getLineNumber() {
        return 0;
    }

    public String getText() {
        return null;
    }

    public int getType() {
        return this.type;
    }

    public ResXmlNode getXmlNode() {
        return this.xmlNode;
    }

    public int getDepth() {
        return this.getXmlNode().getDepth();
    }

    public String getEventName() {
        int t = this.getType();
        String[] types = XmlPullParser.TYPES;
        if (t >= 0 && t < types.length) {
            return types[t];
        }
        return "unknown-" + t;
    }

    public String toString() {
        String text = this.getText();
        if (text != null && text.length() > 100) {
            text = text.substring(0, 100) + " ...";
        }
        return this.getEventName() + " {" + text + "} ";
    }

    public static ResXmlEvent startComment(ResXmlElement element) {
        String comment = element.getStartComment();
        if (StringsUtil.isEmpty(comment)) {
            return null;
        }
        return new ResXmlEvent(COMMENT, element){

            @Override
            public int getLineNumber() {
                return this.getXmlNode().getStartLineNumber();
            }

            @Override
            public String getText() {
                return ((ResXmlElement)this.getXmlNode()).getStartComment();
            }
        };
    }

    public static ResXmlEvent endComment(ResXmlElement element) {
        String comment = element.getEndComment();
        if (StringsUtil.isEmpty(comment)) {
            return null;
        }
        return new ResXmlEvent(COMMENT, element){

            @Override
            public int getLineNumber() {
                return this.getXmlNode().getEndLineNumber();
            }

            @Override
            public String getText() {
                return ((ResXmlElement)this.getXmlNode()).getEndComment();
            }
        };
    }

    public static ResXmlEvent comment(ResXmlTextNode textNode) {
        String comment = textNode.getComment();
        if (StringsUtil.isEmpty(comment)) {
            return null;
        }
        return new ResXmlEvent(COMMENT, textNode){

            @Override
            public String getText() {
                return ((ResXmlTextNode)this.getXmlNode()).getComment();
            }

            @Override
            public int getLineNumber() {
                return this.getXmlNode().getLineNumber();
            }
        };
    }

    public static ResXmlEvent startTag(ResXmlElement element) {
        return new ResXmlEvent(START_TAG, element){

            @Override
            public int getLineNumber() {
                return this.getXmlNode().getStartLineNumber();
            }

            @Override
            public String getText() {
                return ((ResXmlElement)this.getXmlNode()).getName(false);
            }
        };
    }

    public static ResXmlEvent endTag(ResXmlElement element) {
        return new ResXmlEvent(END_TAG, element){

            @Override
            public int getLineNumber() {
                return this.getXmlNode().getEndLineNumber();
            }

            @Override
            public String getText() {
                return ((ResXmlElement)this.getXmlNode()).getName(false);
            }
        };
    }

    public static ResXmlEvent text(ResXmlTextNode resXmlText) {
        if (resXmlText.isIndent()) {
            return null;
        }
        return new ResXmlEvent(TEXT, resXmlText){

            @Override
            public int getLineNumber() {
                return this.getXmlNode().getLineNumber();
            }

            @Override
            public String getText() {
                return ((ResXmlTextNode)this.getXmlNode()).getText();
            }
        };
    }

    public static ResXmlEvent startDocument(ResXmlDocument xmlDocument) {
        return new ResXmlEvent(START_DOCUMENT, xmlDocument){

            @Override
            public int getLineNumber() {
                return this.getXmlNode().getStartLineNumber();
            }
        };
    }

    public static ResXmlEvent endDocument(ResXmlDocument xmlDocument) {
        return new ResXmlEvent(END_DOCUMENT, xmlDocument){

            @Override
            public int getLineNumber() {
                return this.getXmlNode().getEndLineNumber();
            }
        };
    }
}

