/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.xml.ElementChunkReader;
import com.reandroid.arsc.chunk.xml.ResXmlChunkList;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlEndElement;
import com.reandroid.arsc.chunk.xml.ResXmlEndNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlNodeList;
import com.reandroid.arsc.chunk.xml.ResXmlStartElement;
import com.reandroid.arsc.chunk.xml.ResXmlStartNamespaceList;
import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;

public class ResXmlElementChunk
extends FixedBlockContainer {
    private final ResXmlStartNamespaceList mStartNamespaceList;
    private final ResXmlStartElement mStartElement;
    private final ResXmlNodeList mNodeList;
    private final ResXmlEndElement mEndElement;
    private final ResXmlChunkList<ResXmlEndNamespace> mEndNamespaceList;

    public ResXmlElementChunk() {
        super(5);
        ResXmlChunkList<ResXmlEndNamespace> endNamespaceList = new ResXmlChunkList<ResXmlEndNamespace>();
        this.mStartNamespaceList = new ResXmlStartNamespaceList(endNamespaceList);
        ResXmlEndElement endElement = new ResXmlEndElement();
        this.mStartElement = new ResXmlStartElement(endElement);
        this.mNodeList = new ResXmlNodeList();
        this.mEndElement = endElement;
        this.mEndNamespaceList = endNamespaceList;
        this.addChild(0, this.mStartNamespaceList);
        this.addChild(1, this.mStartElement);
        this.addChild(2, this.mNodeList);
        this.addChild(3, this.mEndElement);
        this.addChild(4, this.mEndNamespaceList);
    }

    public ResXmlNodeList getNodeList() {
        return this.mNodeList;
    }

    ResXmlElement element() {
        return this.getParentInstance(ResXmlElement.class);
    }

    void onPreRemove() {
        this.mStartNamespaceList.clear();
        this.mEndNamespaceList.clearChildes();
        this.mStartElement.onPreRemove();
    }

    public void setName(String name) {
        ResXmlStartElement startElement = this.getStartElement();
        if (name == null) {
            startElement.setName(null);
            return;
        }
        String prefix = XMLUtil.splitPrefix(name);
        name = XMLUtil.splitName(name);
        startElement.setName(name);
        if (prefix == null) {
            return;
        }
        ResXmlNamespace namespace = this.element().getOrCreateNamespaceForPrefix(prefix);
        if (namespace != null) {
            startElement.setNamespaceReference(namespace.getUriReference());
        }
    }

    ResXmlStartNamespaceList getStartNamespaceList() {
        return this.mStartNamespaceList;
    }

    ResXmlStartElement getStartElement() {
        return this.mStartElement;
    }

    ResXmlEndElement getEndElement() {
        return this.mEndElement;
    }

    void linkStringReferences() {
        this.mStartElement.linkStringReferences();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        new ElementChunkReader(this).read(reader);
    }
}

