/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.container.SingleBlockContainer;
import com.reandroid.arsc.header.XmlNodeHeader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.arsc.pool.ResXmlStringPool;
import com.reandroid.utils.ObjectsUtil;

class BaseXmlChunk
extends Chunk<XmlNodeHeader> {
    private final IntegerItem mNamespaceReference = new IntegerItem(NULL_REFERENCE);
    private final IntegerItem mStringReference = new IntegerItem(NULL_REFERENCE);
    public static final int NULL_REFERENCE = ObjectsUtil.of(-1);

    BaseXmlChunk(ChunkType chunkType, SingleBlockContainer<Block> firstPlaceHolder, int initialChildesCount) {
        super(new XmlNodeHeader(chunkType), firstPlaceHolder, initialChildesCount + 2);
        this.addChild(this.mNamespaceReference);
        this.addChild(this.mStringReference);
    }

    BaseXmlChunk(ChunkType chunkType, int initialChildesCount) {
        this(chunkType, new SingleBlockContainer<Block>(), initialChildesCount);
    }

    void onPreRemove() {
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return;
        }
        stringPool.removeReference(((XmlNodeHeader)this.getHeaderBlock()).getCommentReference());
        stringPool.removeReference(this.mNamespaceReference);
        stringPool.removeReference(this.mStringReference);
    }

    void linkStringReferences() {
        this.linkStringReference(((XmlNodeHeader)this.getHeaderBlock()).getCommentReference());
        this.linkStringReference(this.mNamespaceReference);
        this.linkStringReference(this.mStringReference);
    }

    private void linkStringReference(IntegerItem item) {
        ResXmlString xmlString = this.getResXmlString(item.get());
        if (xmlString != null) {
            xmlString.addReference(item);
        }
    }

    void unLinkStringReference(IntegerItem item) {
        ResXmlString xmlString = this.getResXmlString(item.get());
        if (xmlString != null) {
            xmlString.removeReference(item);
        }
    }

    public void setLineNumber(int val) {
        ((XmlNodeHeader)this.getHeaderBlock()).getLineNumber().set(val);
    }

    public int getLineNumber() {
        return ((XmlNodeHeader)this.getHeaderBlock()).getLineNumber().get();
    }

    public void setCommentReference(int reference) {
        if (reference == this.getCommentReference()) {
            return;
        }
        IntegerItem comment = ((XmlNodeHeader)this.getHeaderBlock()).getCommentReference();
        this.unLinkStringReference(comment);
        ((XmlNodeHeader)this.getHeaderBlock()).getCommentReference().set(reference);
        this.linkStringReference(comment);
    }

    public int getCommentReference() {
        return ((XmlNodeHeader)this.getHeaderBlock()).getCommentReference().get();
    }

    void setNamespaceReference(int value) {
        if (value == this.getNamespaceReference()) {
            return;
        }
        this.unLinkStringReference(this.mNamespaceReference);
        this.mNamespaceReference.set(value);
        this.linkStringReference(this.mNamespaceReference);
    }

    int getNamespaceReference() {
        return this.mNamespaceReference.get();
    }

    void setStringReference(int reference) {
        if (reference == this.getStringReference()) {
            return;
        }
        this.unLinkStringReference(this.mStringReference);
        this.mStringReference.set(reference);
        this.linkStringReference(this.mStringReference);
    }

    int getStringReference() {
        return this.mStringReference.get();
    }

    void setString(String str) {
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool != null) {
            ResXmlString xmlString = stringPool.getOrCreate(str);
            this.setStringReference(xmlString.getIndex());
        }
    }

    ResXmlStringPool getStringPool() {
        for (Block parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof ResXmlDocument) {
                return ((ResXmlDocument)parent).getStringPool();
            }
            if (!(parent instanceof ResXmlElement)) continue;
            return ((ResXmlElement)parent).getStringPool();
        }
        return null;
    }

    ResXmlString getResXmlString(int reference) {
        if (reference == NULL_REFERENCE) {
            return null;
        }
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool != null) {
            return (ResXmlString)stringPool.get(reference);
        }
        return null;
    }

    String getString(int reference) {
        ResXmlString xmlString = this.getResXmlString(reference);
        if (xmlString != null) {
            return xmlString.get();
        }
        return null;
    }

    ResXmlString getOrCreateString(String str) {
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return null;
        }
        return stringPool.getOrCreate(str);
    }

    int getOrCreateStringReference(String str) {
        ResXmlString xmlString = this.getOrCreateString(str);
        if (xmlString != null) {
            return xmlString.getIndex();
        }
        return NULL_REFERENCE;
    }

    public String getName() {
        return this.getString(this.getStringReference());
    }

    public String getUri() {
        return this.getString(this.getNamespaceReference());
    }

    public String getComment() {
        return this.getString(this.getCommentReference());
    }

    public void setComment(String comment) {
        if (comment == null || comment.length() == 0) {
            this.setCommentReference(NULL_REFERENCE);
        } else {
            String old = this.getComment();
            if (comment.equals(old)) {
                return;
            }
            ResXmlString xmlString = this.getOrCreateString(comment);
            this.setCommentReference(xmlString.getIndex());
        }
    }

    public ResXmlElement getNodeElement() {
        return this.getParentInstance(ResXmlElement.class);
    }

    @Override
    protected void onChunkRefreshed() {
    }

    @Override
    public String toString() {
        ChunkType chunkType = ((XmlNodeHeader)this.getHeaderBlock()).getChunkType();
        if (chunkType == null) {
            return super.toString();
        }
        return chunkType.toString() + ": line=" + this.getLineNumber() + " {" + this.getName() + "}";
    }
}

