/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.array.LibraryInfoArray;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.header.LibraryHeader;
import com.reandroid.arsc.value.LibraryInfo;
import java.util.Iterator;

public class LibraryBlock
extends Chunk<LibraryHeader>
implements Iterable<LibraryInfo> {
    private final LibraryInfoArray mLibraryInfoArray;

    public LibraryBlock() {
        super(new LibraryHeader(), 1);
        LibraryHeader header = (LibraryHeader)this.getHeaderBlock();
        this.mLibraryInfoArray = new LibraryInfoArray(header.getCountItem());
        this.addChild(this.mLibraryInfoArray);
    }

    public boolean containsLibraryInfo(String packageName) {
        if (this.isEmpty()) {
            return false;
        }
        return this.getLibraryInfoArray().containsLibraryInfo(packageName);
    }

    public LibraryInfoArray getLibraryInfoArray() {
        return this.mLibraryInfoArray;
    }

    public void addLibraryInfo(LibraryBlock libraryBlock) {
        if (libraryBlock == null) {
            return;
        }
        for (LibraryInfo info : libraryBlock.getLibraryInfoArray().listItems()) {
            this.addLibraryInfo(info);
        }
    }

    public void addLibraryInfo(LibraryInfo info) {
        if (info == null) {
            return;
        }
        this.getLibraryInfoArray().add(info);
        ((LibraryHeader)this.getHeaderBlock()).getCountItem().set(this.mLibraryInfoArray.size());
    }

    public LibraryInfo newLibraryInfo() {
        return (LibraryInfo)this.mLibraryInfoArray.createNext();
    }

    public int size() {
        return this.mLibraryInfoArray.size();
    }

    @Override
    public Iterator<LibraryInfo> iterator() {
        return this.getLibraryInfoArray().iterator(true);
    }

    @Override
    public boolean isNull() {
        return this.isEmpty();
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public void setLibraryCount(int count) {
        ((LibraryHeader)this.getHeaderBlock()).getCountItem().set(count);
        this.mLibraryInfoArray.setSize(count);
    }

    @Override
    protected void onChunkRefreshed() {
        ((LibraryHeader)this.getHeaderBlock()).getCountItem().set(this.mLibraryInfoArray.size());
    }

    public void merge(LibraryBlock libraryBlock) {
        if (libraryBlock == null || libraryBlock == this) {
            return;
        }
        this.getLibraryInfoArray().merge(libraryBlock.getLibraryInfoArray());
    }
}

