/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.base;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.common.ArraySupplier;
import com.reandroid.utils.NumbersUtil;
import com.reandroid.utils.collection.FilterIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Predicate;

public abstract class BlockArray<T extends Block>
extends BlockList<T>
implements Creator<T>,
ArraySupplier<T> {
    public BlockArray() {
        this.setCreator(this);
    }

    public BlockArray(Creator<? extends T> creator) {
        super(creator);
    }

    @Override
    protected void onReadBytes(BlockReader reader) throws IOException {
        super.readChildes(reader);
    }

    @Override
    public void setSize(int size) {
        int max = this.size();
        for (int i = size; i < max; ++i) {
            this.onPreRemove(this.get(i));
        }
        super.setSize(size);
    }

    public void removeAllNull(int start) {
        int lastCount = this.size() - start;
        if (lastCount <= 0) {
            return;
        }
        int count = NumbersUtil.min(lastCount, this.countFromLast(this.nullPredicate()));
        this.setSize(this.size() - count);
    }

    public Iterable<T> listItems() {
        return this.listItems(false);
    }

    public Iterable<T> listItems(boolean skipNullBlocks) {
        return () -> this.iterator(skipNullBlocks);
    }

    public final int countNonNull() {
        return this.countIf(this.nonNullPredicate());
    }

    @Override
    public int indexOf(Object block) {
        int i = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Block item = (Block)iterator.next();
            if (block == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object block) {
        int result = -1;
        int i = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Block item = (Block)iterator.next();
            if (block == item) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public Iterator<T> iterator(boolean skipNullBlock) {
        if (skipNullBlock) {
            return this.iterator(this.nonNullPredicate());
        }
        return super.iterator();
    }

    public Iterator<T> iterator(boolean skipNullBlock, int start, int size) {
        Iterator iterator = super.iterator(start, size);
        if (skipNullBlock) {
            iterator = FilterIterator.of(iterator, this.nonNullPredicate());
        }
        return iterator;
    }

    public void clear() {
        super.clearChildes();
    }

    @Override
    public void onPreRemove(T block) {
        ((Block)block).setParent(null);
        ((Block)block).setIndex(-1);
    }

    private Predicate<? super T> nullPredicate() {
        return Block::isNull;
    }

    private Predicate<? super T> nonNullPredicate() {
        return block -> !block.isNull();
    }
}

