/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockArray;
import com.reandroid.arsc.io.BlockLoad;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.value.StagedAliasEntry;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import java.io.IOException;
import java.util.Iterator;

public class StagedAliasEntryArray
extends BlockArray<StagedAliasEntry>
implements BlockLoad,
JSONConvert<JSONArray> {
    private final IntegerItem count;

    public StagedAliasEntryArray(IntegerItem count) {
        this.count = count;
        this.count.setBlockLoad(this);
    }

    public boolean contains(StagedAliasEntry aliasEntry) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StagedAliasEntry entry = (StagedAliasEntry)iterator.next();
            if (!entry.isEqual(aliasEntry)) continue;
            return true;
        }
        return false;
    }

    public StagedAliasEntry searchByStagedResId(int stagedResId) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StagedAliasEntry entry = (StagedAliasEntry)iterator.next();
            if (stagedResId != entry.getStagedResId()) continue;
            return entry;
        }
        return null;
    }

    @Override
    protected void onRefreshed() {
        this.updateCount();
    }

    @Override
    public StagedAliasEntry newInstance() {
        return new StagedAliasEntry();
    }

    @Override
    public void onBlockLoaded(BlockReader reader, Block sender) throws IOException {
        if (sender == this.count) {
            this.setSize(this.count.get());
        }
    }

    private void updateCount() {
        this.count.set(this.size());
    }

    @Override
    public JSONArray toJson() {
        if (this.size() == 0) {
            return null;
        }
        Iterator iterator = this.iterator();
        JSONArray jsonArray = new JSONArray(this.size());
        int i = 0;
        while (iterator.hasNext()) {
            StagedAliasEntry item = (StagedAliasEntry)iterator.next();
            jsonArray.put(i, item.toJson());
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        this.clear();
        if (json == null) {
            return;
        }
        int length = json.length();
        this.setSize(length);
        for (int i = 0; i < length; ++i) {
            ((StagedAliasEntry)this.get(i)).fromJson(json.getJSONObject(i));
        }
    }
}

