/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.writer;

import com.reandroid.apk.APKLogger;
import com.reandroid.archive.Archive;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.ZipSignature;
import com.reandroid.archive.block.CentralEntryHeader;
import com.reandroid.archive.block.DataDescriptor;
import com.reandroid.archive.block.LocalFileHeader;
import com.reandroid.archive.io.CountingOutputStream;
import com.reandroid.archive.io.ZipOutput;
import com.reandroid.archive.writer.HeaderInterceptor;
import com.reandroid.archive.writer.ZipAligner;
import com.reandroid.utils.io.FileUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

class OutputSource {
    private final InputSource inputSource;
    private LocalFileHeader lfh;
    private APKLogger apkLogger;
    private HeaderInterceptor headerInterceptor;
    private static final long LOG_LARGE_FILE_SIZE = 2048000L;

    OutputSource(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    void writeBuffer(ZipOutput zipOutput) throws IOException {
        LocalFileHeader lfh = this.getLocalFileHeader();
        InputSource inputSource = this.getInputSource();
        OutputStream rawStream = zipOutput.getOutputStream();
        CountingOutputStream<OutputStream> rawCounter = new CountingOutputStream<OutputStream>(rawStream);
        CountingOutputStream<DeflaterOutputStream> deflateCounter = null;
        if (inputSource.getMethod() != Archive.STORED) {
            DeflaterOutputStream deflaterInputStream = new DeflaterOutputStream(rawCounter, new Deflater(-1, true), true);
            deflateCounter = new CountingOutputStream<DeflaterOutputStream>(deflaterInputStream, false);
        }
        if (deflateCounter != null) {
            rawCounter.disableCrc(true);
            inputSource.write(deflateCounter);
            deflateCounter.close();
            rawCounter.close();
        } else {
            inputSource.write(rawCounter);
        }
        lfh.setCompressedSize(rawCounter.getSize());
        if (deflateCounter != null) {
            lfh.setMethod(Archive.DEFLATED);
            lfh.setCrc(deflateCounter.getCrc32());
            lfh.setSize(deflateCounter.getSize());
        } else {
            lfh.setSize(rawCounter.getSize());
            lfh.setMethod(Archive.STORED);
            lfh.setCrc(rawCounter.getCrc32());
        }
        inputSource.disposeInputSource();
    }

    void writeCEH(ZipOutput zipOutput) throws IOException {
        LocalFileHeader lfh = this.getLocalFileHeader();
        CentralEntryHeader ceh = CentralEntryHeader.fromLocalFileHeader(lfh);
        this.notifyCEHWrite(ceh);
        ceh.writeBytes(zipOutput.getOutputStream());
    }

    void writeDD(ZipOutput apkFileWriter) throws IOException {
        DataDescriptor dataDescriptor = this.getLocalFileHeader().getDataDescriptor();
        if (dataDescriptor == null) {
            return;
        }
        this.notifyDDWrite(dataDescriptor);
        dataDescriptor.writeBytes(apkFileWriter.getOutputStream());
    }

    void writeLFH(ZipOutput zipOutput, ZipAligner zipAligner) throws IOException {
        LocalFileHeader lfh = this.getLocalFileHeader();
        if (zipAligner != null) {
            zipAligner.align(zipOutput.position(), lfh);
        }
        this.notifyLFHWrite(lfh);
        lfh.writeBytes(zipOutput.getOutputStream());
    }

    public void setHeaderInterceptor(HeaderInterceptor interceptor) {
        this.headerInterceptor = interceptor;
    }

    private void notifyLFHWrite(LocalFileHeader lfh) {
        HeaderInterceptor interceptor = this.headerInterceptor;
        if (interceptor != null) {
            interceptor.onWriteLfh(lfh);
        }
    }

    private void notifyCEHWrite(CentralEntryHeader ceh) {
        HeaderInterceptor interceptor = this.headerInterceptor;
        if (interceptor != null) {
            interceptor.onWriteCeh(ceh);
        }
    }

    private void notifyDDWrite(DataDescriptor dataDescriptor) {
        HeaderInterceptor interceptor = this.headerInterceptor;
        if (interceptor != null) {
            interceptor.onWriteDD(dataDescriptor);
        }
    }

    InputSource getInputSource() {
        return this.inputSource;
    }

    LocalFileHeader getLocalFileHeader() {
        if (this.lfh == null) {
            LocalFileHeader lfh = this.createLocalFileHeader();
            lfh.setFileName(this.getInputSource().getAlias());
            lfh.setZipAlign(0);
            lfh.updateDataDescriptor();
            this.lfh = lfh;
        }
        return this.lfh;
    }

    LocalFileHeader createLocalFileHeader() {
        InputSource inputSource = this.getInputSource();
        LocalFileHeader lfh = new LocalFileHeader();
        lfh.setSignature(ZipSignature.LOCAL_FILE);
        lfh.getGeneralPurposeFlag().initDefault();
        lfh.setFileName(inputSource.getAlias());
        lfh.setMethod(inputSource.getMethod());
        return lfh;
    }

    void logLargeFileWrite() {
        APKLogger logger = this.apkLogger;
        if (logger == null) {
            return;
        }
        long size = this.getLocalFileHeader().getDataSize();
        if (size < 2048000L) {
            return;
        }
        this.logFileWrite();
    }

    void logFileWrite() {
        APKLogger logger = this.apkLogger;
        if (logger == null) {
            return;
        }
        long size = this.getLocalFileHeader().getDataSize();
        this.logVerbose("Write [" + FileUtil.toReadableFileSize(size) + "] " + this.getInputSource().getAlias());
    }

    void setAPKLogger(APKLogger logger) {
        this.apkLogger = logger;
    }

    void logVerbose(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logVerbose(msg);
        }
    }
}

