/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.writer;

import com.reandroid.archive.io.ZipFileInput;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class BufferFileInput
extends ZipFileInput {
    private boolean unlocked;

    public BufferFileInput(File file) {
        super(file);
    }

    public void unlock() {
        this.unlocked = true;
    }

    @Override
    public FileChannel getFileChannel() throws IOException {
        if (this.unlocked) {
            return super.getFileChannel();
        }
        throw new IOException("File locked!");
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.unlocked) {
            File file = super.getFile();
            if (file.isFile()) {
                file.delete();
            }
            this.unlocked = false;
        }
    }
}

