/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.io;

import com.reandroid.archive.io.ZipInput;
import com.reandroid.common.BytesInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZipByteInput
extends ZipInput {
    private final byte[] array;
    private int position;
    private final int offset;
    private final int length;

    public ZipByteInput(byte[] array) {
        this(array, 0, array.length);
    }

    public ZipByteInput(byte[] array, int offset, int length) {
        int available;
        if (offset >= array.length) {
            offset = array.length - 1;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (length > (available = array.length - offset)) {
            length = available;
        }
        this.array = array;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public void position(long pos) throws IOException {
        if (pos > this.getLength()) {
            pos = this.getLength() - 1L;
        }
        if (pos < 0L) {
            pos = 0L;
        }
        this.position = (int)pos;
    }

    @Override
    public void close() throws IOException {
        this.position = this.length;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public long getLength() throws IOException {
        return this.length;
    }

    @Override
    public InputStream getInputStream(long offset, long length) throws IOException {
        return new BytesInputStream(this.array, (int)(offset + (long)this.offset), (int)length);
    }

    @Override
    public byte[] getFooter(int minLength) {
        if (minLength <= 0) {
            return new byte[0];
        }
        if (minLength > this.length) {
            if (this.offset == 0) {
                return (byte[])this.array.clone();
            }
            minLength = this.length;
        }
        byte[] bytes = new byte[minLength];
        int offset = this.array.length - this.offset - minLength;
        System.arraycopy(this.array, offset, bytes, 0, minLength);
        return bytes;
    }
}

