/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.block;

import com.reandroid.archive.block.ZipBlock;
import com.reandroid.arsc.item.ByteArray;
import java.io.IOException;
import java.io.InputStream;

public class SignatureFooter
extends ZipBlock {
    public static final int MIN_SIZE = 24;
    private static final int OFFSET_size = 0;
    private static final int OFFSET_magic = 8;
    private static final byte[] APK_SIG_BLOCK_MAGIC = new byte[]{65, 80, 75, 32, 83, 105, 103, 32, 66, 108, 111, 99, 107, 32, 52, 50};

    public SignatureFooter() {
        super(24);
        this.setMagic(APK_SIG_BLOCK_MAGIC);
    }

    @Override
    public int readBytes(InputStream inputStream) throws IOException {
        this.setBytesLength(24, false);
        byte[] bytes = this.getBytesInternal();
        return inputStream.read(bytes, 0, bytes.length);
    }

    public long getSignatureSize() {
        return this.getLong(0);
    }

    public void setSignatureSize(long size) {
        int minLength = 24;
        if (this.countBytes() < minLength) {
            this.setBytesLength(minLength, false);
        }
        this.putLong(0, size);
    }

    public byte[] getMagic() {
        return this.getBytes(8, APK_SIG_BLOCK_MAGIC.length, false);
    }

    public void setMagic(byte[] magic) {
        if (magic == null) {
            magic = new byte[]{};
        }
        int length = 8 + magic.length;
        this.setBytesLength(length, false);
        this.putBytes(magic, 0, 8, magic.length);
    }

    public boolean isValid() {
        return this.getSignatureSize() > 24L && ByteArray.equals(APK_SIG_BLOCK_MAGIC, this.getMagic());
    }

    public void updateMagic() {
        this.setMagic(APK_SIG_BLOCK_MAGIC);
    }

    public String toString() {
        return this.getSignatureSize() + " [" + new String(this.getMagic()) + "]";
    }
}

