/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.archive.Archive;
import com.reandroid.archive.ArchiveUtil;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.Crc32OutputStream;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;

public abstract class InputSource {
    private final String name;
    private String alias;
    private long mCrc;
    private long mLength;
    private int method = Archive.DEFLATED;
    private int sort = -1;
    private String[] splitAlias;
    public static final Comparator<? super InputSource> ALIAS_COMPARATOR = InputSource::compareSortOrAlias;
    private static final String ANDROID_MANIFEST = StringsUtil.toLowercase(AndroidManifestBlock.FILE_NAME);
    private static final String RESOURCES = StringsUtil.toLowercase(TableBlock.FILE_NAME);
    private static final String META_INF = "meta-inf";
    private static final String LIB = "lib";
    private static final String RES = "res";
    private static final String ASSETS = "assets";
    private static final int ORDER_android_manifest = 0;
    private static final int ORDER_resources = 1;
    private static final int ORDER_meta_inf = 2;
    private static final int ORDER_classes = 3;
    private static final int ORDER_lib = 4;
    private static final int ORDER_res = 5;
    private static final int ORDER_assets = 6;
    private static final int LAST_ORDER = 10;

    public InputSource(String name) {
        this.name = name;
        this.alias = ArchiveUtil.sanitizePath(name);
    }

    public byte[] getBytes(int length) throws IOException {
        InputStream inputStream = this.openStream();
        byte[] bytes = new byte[length];
        inputStream.read(bytes, 0, length);
        this.close(inputStream);
        return bytes;
    }

    public void disposeInputSource() {
    }

    public int getSort() {
        return this.sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public void copyAttributes(InputSource other) {
        if (other != null && other != this) {
            this.setSort(other.getSort());
            this.setMethod(other.getMethod());
            this.setAlias(other.getAlias());
        }
    }

    public boolean isUncompressed() {
        return this.getMethod() != Archive.DEFLATED;
    }

    public void setUncompressed(boolean uncompressed) {
        this.method = uncompressed ? Archive.STORED : Archive.DEFLATED;
    }

    public int getMethod() {
        return this.method;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public String getAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.getName();
    }

    public void setAlias(String alias) {
        this.alias = alias;
        this.splitAlias = null;
    }

    public String getSimpleName() {
        return FileUtil.getFileName(this.getAlias());
    }

    public String getSimpleNameWoExtension() {
        return FileUtil.getNameWoExtension(this.getAlias());
    }

    public String getParentPath() {
        return FileUtil.getParent(this.getAlias());
    }

    public String getExtension() {
        return FileUtil.getExtension(this.getAlias());
    }

    private String[] getSplitAlias() {
        if (this.splitAlias == null) {
            String alias = StringsUtil.toLowercase(this.getAlias());
            this.splitAlias = StringsUtil.split(alias, '/');
        }
        return this.splitAlias;
    }

    public void close(InputStream inputStream) throws IOException {
        inputStream.close();
    }

    public File toFile(File dir) {
        String path = this.getAlias();
        path = path.replace('/', File.separatorChar);
        return new File(dir, path);
    }

    public void write(File file) throws IOException {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        this.write(outputStream);
        outputStream.close();
    }

    public long write(OutputStream outputStream) throws IOException {
        return this.write(outputStream, this.openStream());
    }

    private long write(OutputStream outputStream, InputStream inputStream) throws IOException {
        int len;
        long result = 0L;
        byte[] buffer = new byte[1024000];
        while ((len = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, len);
            result += (long)len;
        }
        this.close(inputStream);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public long getLength() throws IOException {
        if (this.mLength == 0L) {
            this.calculateCrc();
        }
        return this.mLength;
    }

    public long getCrc() throws IOException {
        if (this.mCrc == 0L) {
            this.calculateCrc();
        }
        return this.mCrc;
    }

    public abstract InputStream openStream() throws IOException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InputSource)) {
            return false;
        }
        InputSource that = (InputSource)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getName();
    }

    private void calculateCrc() throws IOException {
        Crc32OutputStream outputStream = new Crc32OutputStream();
        this.write(outputStream);
        this.mCrc = outputStream.getValue();
        this.mLength = outputStream.getLength();
    }

    public static int getDexNumber(String name) {
        if (name.equals("classes.dex")) {
            return 0;
        }
        String prefix = "classes";
        String ext = ".dex";
        if (!name.startsWith(prefix) || !name.endsWith(ext)) {
            return -1;
        }
        String num = name.substring(prefix.length(), name.length() - ext.length());
        try {
            int value = Integer.parseInt(num);
            if (value > 0) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public static int compareDex(String dex1, String dex2) {
        int d2;
        int d1 = InputSource.getDexNumber(dex1);
        if (d1 == (d2 = InputSource.getDexNumber(dex2))) {
            return 0;
        }
        if (d1 < 0) {
            return 1;
        }
        if (d2 < 0) {
            return -1;
        }
        return Integer.compare(d1, d2);
    }

    private static int getSortOrder(String[] alias) {
        int length = alias.length;
        if (length == 0) {
            return 10;
        }
        String name = alias[0];
        if (StringsUtil.isEmpty(name)) {
            return 10;
        }
        if (length != 1) {
            if (META_INF.equals(name)) {
                return 2;
            }
            if (LIB.equals(name)) {
                return 4;
            }
            if (RES.equals(name)) {
                return 5;
            }
            if (ASSETS.equals(name)) {
                return 6;
            }
            return 10;
        }
        if (ANDROID_MANIFEST.equals(name)) {
            return 0;
        }
        if (RESOURCES.equals(name)) {
            return 1;
        }
        if (name.startsWith("classes") && name.endsWith(".dex")) {
            return 3;
        }
        return 10;
    }

    private static int compareAlias(InputSource source1, InputSource source2) {
        int order2;
        String[] alias1 = source1.getSplitAlias();
        String[] alias2 = source2.getSplitAlias();
        int order1 = InputSource.getSortOrder(alias1);
        if (order1 != (order2 = InputSource.getSortOrder(alias2))) {
            return CompareUtil.compare(order1, order2);
        }
        if (order1 == 3) {
            return InputSource.compareDex(alias1[0], alias2[0]);
        }
        return StringsUtil.compare(alias1, alias2);
    }

    static int compareSortOrAlias(InputSource source1, InputSource source2) {
        if (source1 == source2) {
            return 0;
        }
        if (source1 == null) {
            return 1;
        }
        if (source2 == null) {
            return -1;
        }
        int sort1 = source1.getSort();
        int sort2 = source1.getSort();
        if (sort1 == -1 && sort2 == -1) {
            return InputSource.compareAlias(source1, source2);
        }
        if (sort1 == -1) {
            return 1;
        }
        if (sort2 == -1) {
            return -1;
        }
        return Integer.compare(sort1, sort2);
    }
}

