/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.smali;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ValueType;
import java.util.HashMap;
import java.util.Map;
import org.jf.baksmali.CommentProvider;

public class ResourceComment
extends CommentProvider {
    private final TableBlock tableBlock;
    private final PackageBlock packageBlock;
    private final Map<Integer, String> mCommentCache;

    public ResourceComment(TableBlock tableBlock) {
        this.tableBlock = tableBlock;
        this.packageBlock = tableBlock.pickOne();
        this.mCommentCache = new HashMap<Integer, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getComment(int resourceId) {
        if (!PackageBlock.isResourceId(resourceId)) {
            return null;
        }
        ResourceComment resourceComment = this;
        synchronized (resourceComment) {
            String comment = this.mCommentCache.get(resourceId);
            if (comment != null) {
                return comment;
            }
            comment = this.buildComment(resourceId);
            if (comment != null) {
                this.mCommentCache.put(resourceId, comment);
            }
            return comment;
        }
    }

    private String buildComment(int resourceId) {
        ResourceEntry resourceEntry = this.tableBlock.getResource(resourceId);
        if (resourceEntry == null || !resourceEntry.isDeclared()) {
            return null;
        }
        String ref = resourceEntry.buildReference(this.packageBlock, ValueType.REFERENCE);
        if (resourceEntry.getPackageBlock().getTableBlock() != this.tableBlock) {
            return ref;
        }
        if ("id".equals(resourceEntry.getType())) {
            return ref;
        }
        Entry entry = resourceEntry.get();
        if (entry == null) {
            return ref;
        }
        ResValue resValue = entry.getResValue();
        if (resValue == null) {
            return ref;
        }
        String decoded = resValue.decodeValue();
        if (decoded == null) {
            return ref;
        }
        if (decoded.length() > 100) {
            decoded = decoded.substring(0, 100) + " ...";
        }
        return ref + " '" + this.escapeNewLines(decoded) + "'";
    }

    private String escapeNewLines(String str) {
        StringBuilder builder = null;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char ch;
            char escaped = ch = str.charAt(i);
            if (ch == '\n') {
                escaped = 'n';
            } else if (ch == '\r') {
                escaped = 'r';
            } else if (ch == '\t') {
                escaped = 't';
            }
            if (escaped != ch) {
                if (builder == null) {
                    builder = new StringBuilder(length + 2);
                    builder.append(str, 0, i);
                }
                builder.append('\\');
                builder.append(escaped);
                continue;
            }
            if (builder == null) continue;
            builder.append(ch);
        }
        if (builder != null) {
            str = builder.toString();
        }
        return str;
    }
}

