/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.protect;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apkeditor.protect.Protector;
import com.reandroid.apkeditor.protect.ProtectorOptions;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.ComputeIterator;
import java.util.Set;

public abstract class Confuser
implements APKLogger {
    private final Protector protector;
    private final String logTag;
    private Set<String> filePaths;

    public Confuser(Protector protector, String logTag) {
        this.protector = protector;
        this.logTag = logTag;
    }

    public abstract void confuse();

    public boolean containsFilePath(String path) {
        return this.getFilePaths().contains(path);
    }

    public void onPathChanged(String original, String newPath) {
        Set<String> filePaths = this.getFilePaths();
        filePaths.add(newPath);
        this.logVerbose(original + " -> " + newPath);
    }

    public Set<String> getFilePaths() {
        if (this.filePaths == null) {
            ZipEntryMap zipEntryMap = this.getApkModule().getZipEntryMap();
            this.filePaths = CollectionUtil.toHashSet(ComputeIterator.of(zipEntryMap.iterator(), InputSource::getAlias));
            this.filePaths.addAll(CollectionUtil.toHashSet(ComputeIterator.of(zipEntryMap.iterator(), InputSource::getName)));
        }
        return this.filePaths;
    }

    public boolean isKeepType(String type) {
        return this.getOptions().isKeepType(type);
    }

    public boolean isKeepAllTypes() {
        return this.getOptions().isKeepAllTypes();
    }

    public Protector getProtector() {
        return this.protector;
    }

    public ProtectorOptions getOptions() {
        return this.getProtector().getOptions();
    }

    public ApkModule getApkModule() {
        return this.getProtector().getApkModule();
    }

    @Override
    public void logMessage(String msg) {
        this.protector.logMessage(this.logTag + msg);
    }

    @Override
    public void logError(String msg, Throwable tr) {
        this.protector.logError(msg, tr);
    }

    @Override
    public void logVerbose(String msg) {
        this.protector.logVerbose(msg);
    }
}

