/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.info;

import com.reandroid.apkeditor.info.InfoWriter;
import com.reandroid.archive.block.CertificateBlock;
import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlTextNode;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.header.StringPoolHeader;
import com.reandroid.arsc.item.StringBlock;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.model.DexLayout;
import com.reandroid.dex.model.DexSectionInfo;
import com.reandroid.dex.sections.Marker;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.CollectionUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class InfoWriterText
extends InfoWriter {
    private static final String ARRAY_TAB = "     ";

    public InfoWriterText(Writer writer) {
        super(writer);
    }

    @Override
    public void writeStringPool(String source, StringPool<?> stringPool) throws IOException {
        Writer writer = this.getWriter();
        writer.write(source);
        writer.write("\n");
        writer.write("String pool of ");
        writer.write(Integer.toString(stringPool.size()));
        writer.write(" unique ");
        if (stringPool.isUtf8()) {
            writer.write("UTF-8 ");
        } else {
            writer.write("UTF-16 ");
        }
        StringPoolHeader header = (StringPoolHeader)stringPool.getHeaderBlock();
        if (!header.isSorted()) {
            writer.write("non-");
        }
        writer.write("sorted strings, ");
        writer.write(Integer.toString(stringPool.size()));
        writer.write(" entries and ");
        writer.write(Integer.toString(stringPool.countStyles()));
        writer.write(" styles using ");
        writer.write(Integer.toString(header.getChunkSize()));
        writer.write(" bytes:");
        writer.write("\n");
        int size = stringPool.size();
        for (int i = 0; i < size; ++i) {
            Object item = stringPool.get(i);
            writer.write("String #");
            writer.write(Integer.toString(i));
            writer.write(": ");
            writer.write(((StringBlock)item).get());
            writer.write("\n");
        }
    }

    @Override
    public void writeXmlDocument(String sourcePath, ResXmlDocument xmlDocument) throws IOException {
        this.writeNameValue("source-path", sourcePath);
        Iterator<ResXmlNode> iterator = xmlDocument.iterator();
        while (iterator.hasNext()) {
            ResXmlNode node = iterator.next();
            if (node instanceof ResXmlElement) {
                this.writeElement((ResXmlElement)node);
                continue;
            }
            if (!(node instanceof ResXmlTextNode)) continue;
            this.writeTextNode(0, (ResXmlTextNode)node);
        }
        Writer writer = this.getWriter();
        writer.flush();
    }

    private void writeElement(ResXmlElement element) throws IOException {
        int indent = element.getDepth() * 2;
        int count = element.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            this.writeNamespace(indent, element.getNamespaceAt(i));
        }
        Writer writer = this.getWriter();
        this.writeIndent(indent += 2);
        writer.write("E: ");
        writer.write(element.getName(true));
        writer.write(" (line=");
        writer.write(Integer.toString(element.getLineNumber()));
        writer.write(")");
        writer.write("\n");
        Iterator<ResXmlAttribute> attributes = element.getAttributes();
        while (attributes.hasNext()) {
            this.writeAttribute(indent, attributes.next());
        }
        this.flush();
        Iterator<ResXmlNode> iterator = element.iterator();
        while (iterator.hasNext()) {
            ResXmlNode node = iterator.next();
            if (node instanceof ResXmlElement) {
                this.writeElement((ResXmlElement)node);
                continue;
            }
            if (!(node instanceof ResXmlTextNode)) continue;
            this.writeTextNode(indent, (ResXmlTextNode)node);
        }
    }

    private void writeTextNode(int indent, ResXmlTextNode textNode) throws IOException {
        Writer writer = this.getWriter();
        this.writeIndent(indent + 2);
        writer.write("T: \"");
        writer.write(textNode.getText());
        writer.write("\"");
        writer.write("\n");
    }

    private void writeNamespace(int indent, ResXmlNamespace namespace) throws IOException {
        Writer writer = this.getWriter();
        this.writeIndent(indent);
        writer.write("N: ");
        writer.write(namespace.getPrefix());
        writer.write("=");
        writer.write(namespace.getUri());
        writer.write("\n");
    }

    private void writeAttribute(int indent, ResXmlAttribute attribute) throws IOException {
        Writer writer = this.getWriter();
        this.writeIndent(indent + 2);
        writer.write("A: ");
        ResXmlNamespace namespace = attribute.getNamespace();
        if (namespace != null) {
            writer.write(namespace.getPrefix());
            writer.append(':');
        }
        writer.write(attribute.getName());
        int id = attribute.getNameId();
        if (id != 0) {
            writer.append('(');
            writer.write(HexUtil.toHex8(id));
            writer.append(')');
        }
        writer.append('=');
        ValueType valueType = attribute.getValueType();
        if (valueType == ValueType.STRING) {
            writer.append('\"');
            writer.write(attribute.getDataAsPoolString().getXml());
            writer.append('\"');
            writer.write(" (Raw: \"");
            writer.write(attribute.getValueString());
            writer.write("\")");
        } else if (valueType == ValueType.BOOLEAN) {
            writer.append('\"');
            writer.write(attribute.getValueAsBoolean() ? "true" : "false");
            writer.append('\"');
        } else {
            writer.write("(type ");
            writer.write(HexUtil.toHex(valueType.getByte() & 0xFF, 1));
            writer.write(")");
            writer.write(HexUtil.toHex(attribute.getData(), 1));
        }
        writer.write("\n");
    }

    @Override
    public void writeCertificates(List<CertificateBlock> certificateList, boolean base64) throws IOException {
        Writer writer = this.getWriter();
        writer.write("\n");
        this.writeNameValue("Certificates", certificateList.size());
        for (CertificateBlock certificateBlock : certificateList) {
            this.writeWithTab(writer, ARRAY_TAB, certificateBlock.printCertificate());
            if (!base64) continue;
            writer.write(ARRAY_TAB);
            writer.write("Base64: ");
            writer.write(InfoWriterText.toBase64(certificateBlock.getCertificateBytes()));
            writer.write("\n");
        }
        this.flush();
    }

    @Override
    public void writeDexInfo(DexFile dexFile, boolean writeSectionInfo) throws IOException {
        Writer writer = this.getWriter();
        writer.write("\n");
        this.writeNameValue("Name", dexFile.getFileName());
        if (dexFile.isMultiLayout()) {
            int size = dexFile.size();
            for (int i = 0; i < size; ++i) {
                this.writeLayout(dexFile.getLayout(i));
            }
            this.writeNameValue("TotalClasses", dexFile.getDexClassesCountForDebug());
        } else if (dexFile.size() != 0) {
            this.writeLayout(dexFile.getFirst());
        } else {
            writer.write("EMPTY DEX");
            writer.write("\n");
        }
        writer.flush();
    }

    private void writeLayout(DexLayout layout) throws IOException {
        Writer writer = this.getWriter();
        if (layout.isMultiLayoutEntry()) {
            writer.write(layout.getName());
            writer.write(", ");
        }
        this.writeNameValue("Version", layout.getVersion());
        this.writeMarkers(layout.getMarkers());
        writer.write("Sections:");
        Iterator<DexSectionInfo> iterator = layout.getSectionInfo();
        while (iterator.hasNext()) {
            DexSectionInfo sectionInfo = iterator.next();
            writer.write("\n");
            writer.write(ARRAY_TAB);
            writer.write(sectionInfo.print(false));
        }
        writer.write("\n");
    }

    private void writeMarkers(Iterator<Marker> iterator) throws IOException {
        Writer writer = this.getWriter();
        List<Marker> markersList = CollectionUtil.toList(iterator);
        if (markersList.size() != 0) {
            writer.write("Markers:");
            for (Marker marker : markersList) {
                writer.write("\n");
                writer.write(ARRAY_TAB);
                writer.write(marker.toString());
            }
        }
    }

    @Override
    public void writeResources(PackageBlock packageBlock, List<String> typeFilters, boolean writeEntries) throws IOException {
        Writer writer = this.getWriter();
        writer.write("Package name=");
        writer.write(packageBlock.getName());
        writer.write(" id=");
        writer.write(HexUtil.toHex2((byte)packageBlock.getId()));
        writer.write("\n");
        packageBlock.sortTypes();
        for (SpecTypePair specTypePair : packageBlock.listSpecTypePairs()) {
            if (!this.contains(specTypePair, typeFilters)) continue;
            this.writeResources(specTypePair, writeEntries);
        }
    }

    public void writeResources(SpecTypePair specTypePair, boolean writeEntries) throws IOException {
        Writer writer = this.getWriter();
        writer.write("  type ");
        writer.write(specTypePair.getTypeName());
        writer.write(" id=");
        writer.write(Integer.toString(specTypePair.getId()));
        writer.write(" entryCount=");
        writer.write(Integer.toString(specTypePair.getHighestEntryCount()));
        writer.write("\n");
        Iterator<ResourceEntry> iterator = specTypePair.getResources();
        while (iterator.hasNext()) {
            ResourceEntry resourceEntry = iterator.next();
            this.writeResources(resourceEntry, writeEntries);
        }
    }

    @Override
    public void writeResources(ResourceEntry resourceEntry, boolean writeEntries) throws IOException {
        if (resourceEntry.isEmpty()) {
            return;
        }
        Writer writer = this.getWriter();
        writer.write("    ");
        writer.write("resource");
        writer.write(" ");
        writer.write(HexUtil.toHex8(resourceEntry.getResourceId()));
        writer.write(" ");
        writer.write(resourceEntry.getType());
        writer.write("/");
        writer.write(resourceEntry.getName());
        writer.write("\n");
        if (writeEntries) {
            this.writeEntries(resourceEntry);
        }
        writer.flush();
    }

    public void writeEntries(ResourceEntry entryList) throws IOException {
        for (Entry entry : entryList) {
            this.writeEntry(entry);
        }
    }

    public void writeEntry(Entry entry) throws IOException {
        Writer writer = this.getWriter();
        writer.write("      (");
        writer.write(entry.getResConfig().getQualifiers());
        writer.write(") ");
        if (entry.isComplex()) {
            this.writeBagEntry(entry);
        } else {
            this.writeResEntry(entry);
        }
        writer.flush();
    }

    private void writeResEntry(Entry entry) throws IOException {
        ResValue resValue = entry.getResValue();
        if (resValue == null) {
            return;
        }
        Writer writer = this.getWriter();
        writer.write(InfoWriterText.getValueAsString(resValue));
        writer.write("\n");
    }

    private void writeBagEntry(Entry entry) throws IOException {
        Writer writer = this.getWriter();
        ResValueMapArray mapArray = entry.getResValueMapArray();
        writer.write(" size=");
        writer.write(Integer.toString(mapArray.getCount()));
        writer.write(" parent=");
        writer.write(HexUtil.toHex8(((ResTableMapEntry)entry.getTableEntry()).getParentId()));
        writer.write("\n");
        for (ResValueMap resValueMap : mapArray.getChildes()) {
            this.writeValueMap(resValueMap);
        }
    }

    private void writeValueMap(ResValueMap resValueMap) throws IOException {
        Writer writer = this.getWriter();
        writer.write("        ");
        String name = resValueMap.decodeName();
        if (name != null) {
            writer.write(name);
            writer.write("(");
        }
        writer.write(HexUtil.toHex8(resValueMap.getNameId()));
        if (name != null) {
            writer.write(")");
        }
        writer.write("=");
        writer.write(InfoWriterText.getValueAsString(resValueMap));
        writer.write("\n");
    }

    @Override
    public void writePackageNames(Collection<PackageBlock> packageBlocks) throws IOException {
        if (packageBlocks == null || packageBlocks.size() == 0) {
            return;
        }
        Writer writer = this.getWriter();
        writer.write("resource-packages");
        writer.write("  [ count ");
        writer.write(Integer.toString(packageBlocks.size()));
        writer.write("]");
        writer.write("\n");
        for (PackageBlock packageBlock : packageBlocks) {
            writer.write(ARRAY_TAB);
            writer.write(HexUtil.toHex2((byte)packageBlock.getId()));
            writer.write("  \"");
            writer.write(packageBlock.getName());
            writer.write("\"");
            writer.write("\n");
        }
    }

    @Override
    public void writeEntries(String name, List<Entry> entryList) throws IOException {
        if (entryList == null || entryList.size() == 0) {
            return;
        }
        Entry first = entryList.get(0);
        Writer writer = this.getWriter();
        writer.write(name);
        writer.write("  [ configs = ");
        writer.write(Integer.toString(entryList.size()));
        writer.write(", id=");
        writer.write(HexUtil.toHex8(first.getResourceId()));
        writer.write(", type=");
        writer.write(first.getTypeName());
        writer.write(", name=");
        writer.write(first.getName());
        writer.write(" ]");
        writer.write("\n");
        int index = 0;
        for (Entry entry : entryList) {
            writer.write(ARRAY_TAB);
            this.writeEntry(entry);
            writer.write("\n");
            if (++index % 3 != 0) continue;
            writer.flush();
        }
    }

    @Override
    public void writeArray(String name, Object[] values) throws IOException {
        if (values == null) {
            return;
        }
        Writer writer = this.getWriter();
        writer.write(name);
        writer.write("  [ count ");
        writer.write(Integer.toString(values.length));
        writer.write("]");
        writer.write("\n");
        String format = "%0" + InfoWriterText.getDecimalPlaces(values.length) + "d) ";
        int index = 0;
        for (Object value : values) {
            writer.write(ARRAY_TAB);
            writer.write(String.format(format, ++index));
            String text = InfoWriterText.toString(value);
            if (text == null) {
                text = "null";
            }
            writer.write(text);
            writer.write("\n");
            if (index % 3 != 0) continue;
            writer.flush();
        }
    }

    @Override
    public void writeNameValue(String name, Object value) throws IOException {
        String text = InfoWriterText.toString(value);
        if (text == null) {
            return;
        }
        Writer writer = this.getWriter();
        writer.write(name);
        writer.write("=\"");
        writer.write(text);
        writer.write("\"");
        writer.write("\n");
        writer.flush();
    }

    @Override
    public void flush() throws IOException {
        Writer writer = this.getWriter();
        writer.flush();
    }

    private void writeIndent(int amount) throws IOException {
        InfoWriterText.writeSpaces(this.getWriter(), amount);
    }

    private void writeWithTab(Writer writer, String tab, String value) throws IOException {
        String[] splits;
        for (String line : splits = StringsUtil.split(value, '\n')) {
            writer.write(tab);
            writer.write(line.trim());
            writer.write("\n");
        }
    }

    private static int getDecimalPlaces(int max) {
        int i = 0;
        while (max != 0) {
            ++i;
            max /= 10;
        }
        return i;
    }
}

