/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor;

import com.reandroid.apkeditor.APKEditor;
import com.reandroid.jcommand.CommandStringResource;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Properties;

public class ResourceStrings
implements CommandStringResource {
    private static final String DEFAULT_CONFIG = "";
    public static final ResourceStrings INSTANCE = new ResourceStrings();
    private Properties defaultProperties;
    private Properties properties;
    private String config;
    private boolean ignoreMissingResource;

    private ResourceStrings() {
    }

    @Override
    public String getString(String resourceName) {
        Properties prop = this.getProperties();
        String result = prop.getProperty(resourceName, null);
        if (result == null) {
            prop = this.getDefaultProperties();
            result = prop.getProperty(resourceName, resourceName);
        }
        return result;
    }

    public String getConfig() {
        String config = this.config;
        if (config == null) {
            this.config = config = this.getAvailableConfig(Locale.getDefault());
        }
        return config;
    }

    public void setConfig(Locale locale) {
        this.setConfig(this.getAvailableConfig(locale));
    }

    public void setConfig(String config) {
        if (!ObjectsUtil.equals(this.config, config)) {
            if (!this.hasConfig(config, null)) {
                config = null;
            }
            this.config = config;
            this.properties = null;
        }
    }

    public void setIgnoreMissingResource(boolean ignoreMissingResource) {
        this.ignoreMissingResource = ignoreMissingResource;
    }

    private String getAvailableConfig(Locale locale) {
        if (locale != null) {
            String country;
            String lang = locale.getLanguage();
            if (!this.hasConfig(lang, country = locale.getCountry())) {
                country = null;
                if (!this.hasConfig(lang, null)) {
                    lang = null;
                }
            }
            return this.toConfig(lang, country);
        }
        return DEFAULT_CONFIG;
    }

    private boolean hasConfig(String lang, String country) {
        boolean result = false;
        String path = this.toResourcePath(lang, country);
        try {
            InputStream inputStream = ResourceStrings.class.getResourceAsStream(path);
            if (inputStream != null) {
                result = true;
                inputStream.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    private String toResourcePath(String lang, String country) {
        return "/strings/strings" + this.toConfig(lang, country) + ".properties";
    }

    private String toConfig(String lang, String country) {
        StringBuilder builder = new StringBuilder();
        if (!StringsUtil.isEmpty(lang)) {
            if (lang.charAt(0) != '-') {
                builder.append('-');
            }
            builder.append(lang);
            if (!StringsUtil.isEmpty(country)) {
                if (country.charAt(0) != '-') {
                    builder.append('-');
                }
                builder.append(country);
            }
        }
        if (builder.length() == 0) {
            return DEFAULT_CONFIG;
        }
        return builder.toString();
    }

    public Properties getProperties() {
        Properties properties = this.properties;
        if (properties == null) {
            String config = this.getConfig();
            properties = DEFAULT_CONFIG.equals(config) ? new Properties() : this.loadProperties(config);
            this.properties = properties;
        }
        return properties;
    }

    private Properties getDefaultProperties() {
        Properties properties = this.defaultProperties;
        if (properties == null) {
            this.defaultProperties = properties = this.loadProperties(DEFAULT_CONFIG);
            this.initializeDefaultProperties(properties);
        }
        return properties;
    }

    private void initializeDefaultProperties(Properties properties) {
        properties.put("title_app_name_and_version", APKEditor.getName() + " - " + APKEditor.getVersion());
        properties.put("title_app_repo", APKEditor.getRepo());
    }

    private Properties loadProperties(String config) {
        Properties properties = new Properties();
        String path = this.toResourcePath(config, null);
        InputStream inputStream = ResourceStrings.class.getResourceAsStream(path);
        if (inputStream == null) {
            if (this.ignoreMissingResource) {
                return properties;
            }
            throw new RuntimeException("Missing resource: '" + path + "'");
        }
        try {
            properties.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return properties;
    }
}

