/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor;

import com.reandroid.apkeditor.APKEditor;
import com.reandroid.apkeditor.CommandExecutor;
import com.reandroid.apkeditor.ResourceStrings;
import com.reandroid.arsc.ARSCLib;
import com.reandroid.jcommand.CommandHelpBuilder;
import com.reandroid.jcommand.OptionStringBuilder;
import com.reandroid.jcommand.SubCommandHelpBuilder;
import com.reandroid.jcommand.SubCommandParser;
import com.reandroid.jcommand.annotations.OptionArg;
import com.reandroid.jcommand.exceptions.CommandException;
import java.io.File;
import java.io.IOException;

public class Options {
    @OptionArg(name="-i", description="input_path")
    public File inputFile;
    @OptionArg(name="-o", description="output_path")
    public File outputFile;
    @OptionArg(name="-f", flag=true, description="force_delete")
    public boolean force;
    public String type;
    @OptionArg(name="-h", alternates={"-help", "--help"}, description="help_description", flag=true)
    public boolean help = false;
    private boolean mValidated;
    public static final int PRINT_WIDTH = 80;
    public static final String TYPE_SIG = "sig";
    public static final String TYPE_JSON = "json";
    public static final String TYPE_RAW = "raw";
    public static final String TYPE_XML = "xml";
    public static final String TYPE_TEXT = "text";
    public static final String DEX_LIB_INTERNAL = "internal";
    public static final String DEX_LIB_JF = "jf";

    public String getHelp() {
        SubCommandHelpBuilder builder = new SubCommandHelpBuilder(ResourceStrings.INSTANCE, this.getClass());
        builder.setMaxWidth(80);
        builder.setColumnSeparator("   ");
        return builder.build();
    }

    public void parse(String[] args) {
        SubCommandParser.parse(this, args);
        this.validate();
    }

    public void runCommand() throws IOException {
        CommandExecutor<?> executor = this.newCommandExecutor();
        executor.logMessage(this.toString());
        executor.runCommand();
    }

    public CommandExecutor<?> newCommandExecutor() {
        throw new RuntimeException("Method not implemented");
    }

    public void validate() {
        if (!this.help && !this.mValidated) {
            this.mValidated = true;
            this.validateValues();
        }
    }

    public void validateValues() {
        this.validateInput(true, false);
        this.validateOutput(true);
    }

    public void validateInput(boolean isFile, boolean isDirectory) {
        File file = this.inputFile;
        if (file == null) {
            throw new CommandException("missing_input_file", new Object[0]);
        }
        this.validateInputFile(file, isFile, isDirectory);
    }

    public void validateInputFile(File file, boolean isFile, boolean isDirectory) {
        if (isFile) {
            if (file.isFile()) {
                return;
            }
            if (!isDirectory) {
                throw new CommandException("no_such_file", file);
            }
        }
        if (isDirectory) {
            if (file.isDirectory()) {
                return;
            }
            throw new CommandException("no_such_directory", file);
        }
        if (!file.exists()) {
            throw new CommandException("no_such_file_or_directory", file);
        }
    }

    public void validateOutput(boolean isFile) {
        File file = this.outputFile;
        if (file == null) {
            this.outputFile = file = this.generateOutputFromInput(this.inputFile);
        }
        if (file == null || !file.exists()) {
            return;
        }
        if (isFile != file.isFile()) {
            if (file.isFile()) {
                throw new CommandException("path_is_file_expect_directory", file);
            }
            throw new CommandException("path_is_directory_expect_file", file);
        }
        if (!this.force) {
            throw new CommandException("path_already_exists", file);
        }
    }

    public File generateOutputFromInput(File input) {
        return null;
    }

    public File generateOutputFromInput(File file, String suffix) {
        int i;
        String name = file.getName();
        if (file.isFile() && (i = name.lastIndexOf(46)) > 0) {
            name = name.substring(0, i);
        }
        name = name + suffix;
        File dir = file.getParentFile();
        if (dir == null) {
            return new File(name);
        }
        return new File(dir, name);
    }

    public String toString() {
        OptionStringBuilder builder = new OptionStringBuilder(this);
        builder.setMaxWidth(80);
        builder.setTab2("      ");
        return "Using: " + APKEditor.getName() + " version " + APKEditor.getVersion() + ", " + ARSCLib.getName() + " version " + ARSCLib.getVersion() + "\n" + builder.buildTable();
    }

    public static String getHelp(Class<?> optionClass) {
        CommandHelpBuilder builder = new CommandHelpBuilder(ResourceStrings.INSTANCE, optionClass);
        builder.setMaxWidth(80);
        return builder.build();
    }
}

