/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apkeditor.APKEditor;
import com.reandroid.apkeditor.Options;
import com.reandroid.apkeditor.Util;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.arsc.ARSCLib;
import com.reandroid.arsc.coder.xml.XmlCoderLogger;
import com.reandroid.commons.utils.log.Logger;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public class CommandExecutor<T extends Options>
implements APKLogger,
XmlCoderLogger {
    private final T options;
    private String mLogTag;
    private boolean mEnableLog;

    public CommandExecutor(T options, String logTag) {
        this.options = options;
        this.mLogTag = logTag;
        this.mEnableLog = true;
    }

    @Deprecated
    public void run() throws IOException {
        this.runCommand();
    }

    public void runCommand() throws IOException {
        throw new RuntimeException("Method not implemented");
    }

    protected void delete(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        this.logMessage("Delete: " + file);
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            Util.deleteDir(file);
        }
    }

    protected T getOptions() {
        return this.options;
    }

    protected void applyExtractNativeLibs(ApkModule apkModule, String extractNativeLibs) {
        if (extractNativeLibs != null) {
            Boolean value = "manifest".equalsIgnoreCase(extractNativeLibs) ? (apkModule.hasAndroidManifest() ? apkModule.getAndroidManifest().isExtractNativeLibs() : null) : ("true".equalsIgnoreCase(extractNativeLibs) ? Boolean.TRUE : ("false".equalsIgnoreCase(extractNativeLibs) ? Boolean.FALSE : null));
            this.logMessage("Applying: extractNativeLibs=" + value);
            apkModule.setExtractNativeLibs(value);
        }
    }

    protected void setLogTag(String tag) {
        if (tag == null) {
            tag = "";
        }
        this.mLogTag = tag;
    }

    public void setEnableLog(boolean enableLog) {
        this.mEnableLog = enableLog;
    }

    @Override
    public void logMessage(String msg) {
        if (!this.mEnableLog) {
            return;
        }
        Logger.i(this.mLogTag + msg);
    }

    @Override
    public void logError(String msg, Throwable tr) {
        if (!this.mEnableLog) {
            return;
        }
        Logger.e(this.mLogTag + msg, tr);
    }

    @Override
    public void logVerbose(String msg) {
        if (!this.mEnableLog) {
            return;
        }
        Logger.sameLine(this.mLogTag + msg);
    }

    @Override
    public void logMessage(String tag, String msg) {
        if (!this.mEnableLog) {
            return;
        }
        Logger.sameLine(this.mLogTag + msg);
    }

    @Override
    public void logVerbose(String tag, String msg) {
        if (!this.mEnableLog) {
            return;
        }
        Logger.sameLine(this.mLogTag + msg);
    }

    public void logWarn(String msg) {
        Logger.e(this.mLogTag + msg);
    }

    public void logVersion() {
        this.logMessage("Using: " + APKEditor.getName() + " version " + APKEditor.getVersion() + ", " + ARSCLib.getName() + " version " + ARSCLib.getVersion());
    }

    protected static void clearMeta(ApkModule module) {
        CommandExecutor.removeSignature(module);
        module.setApkSignatureBlock(null);
    }

    protected static void removeSignature(ApkModule module) {
        ZipEntryMap archive = module.getZipEntryMap();
        archive.removeIf(Pattern.compile("^META-INF/.+\\.(([MS]F)|(RSA))"));
        archive.remove("stamp-cert-sha256");
    }
}

