/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.FileMagic;
import com.reandroid.apk.JsonXmlInputSource;
import com.reandroid.apk.xmlencoder.XMLEncodeSource;
import com.reandroid.archive.BlockInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class ResFile
implements Iterable<Entry> {
    private final List<Entry> entryList;
    private final InputSource inputSource;
    private boolean mBinXml;
    private boolean mBinXmlChecked;
    private String mFileExtension;
    private Entry mSelectedEntry;
    public static String EXT_9_PNG = ObjectsUtil.of(".9.png");

    public ResFile(InputSource inputSource, List<Entry> entryList) {
        this.inputSource = inputSource;
        this.entryList = entryList;
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.getEntries().iterator();
    }

    public Iterator<Entry> iterator(Predicate<? super Entry> filter) {
        return FilterIterator.of(this.iterator(), filter);
    }

    public int size() {
        return this.getEntries().size();
    }

    public Entry get(int i) {
        return this.getEntries().get(i);
    }

    public Entry getFirst() {
        if (this.size() != 0) {
            return this.get(0);
        }
        return null;
    }

    public void delete() {
        this.delete(true);
    }

    public void delete(boolean keepResourceId) {
        for (Entry entry : this) {
            entry.setNull(true);
            if (keepResourceId) continue;
            entry.getTypeBlock().removeNullEntries(entry.getId());
        }
        this.getEntries().clear();
    }

    private List<Entry> getEntries() {
        return this.entryList;
    }

    @Deprecated
    public List<Entry> getEntryList() {
        return this.getEntries();
    }

    public PackageBlock getPackageBlock() {
        Entry entry = this.pickOne();
        if (entry != null) {
            return entry.getPackageBlock();
        }
        return null;
    }

    public ResXmlDocument getResXmlDocument() {
        if (!this.isBinaryXml()) {
            return null;
        }
        try {
            return this.readAsXmlDocument();
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public ResXmlDocument readAsXmlDocument() throws IOException {
        BlockInputSource bis;
        Object block;
        InputSource inputSource = this.getInputSource();
        if (inputSource instanceof BlockInputSource && (block = (bis = (BlockInputSource)inputSource).getBlock()) instanceof ResXmlDocument) {
            return (ResXmlDocument)block;
        }
        ResXmlDocument xmlDocument = new ResXmlDocument();
        xmlDocument.setPackageBlock(this.getPackageBlock());
        xmlDocument.readBytes(this.getInputSource().openStream());
        return xmlDocument;
    }

    public String validateTypeDirectoryName() {
        String root = this.getRootNameFromPath();
        if (StringsUtil.isEmpty(root)) {
            root = PackageBlock.RES_DIRECTORY_NAME;
        }
        return this.validateTypeDirectoryName(root);
    }

    public String validateTypeDirectoryName(String root) {
        Entry entry = this.pickOne();
        if (entry == null) {
            return null;
        }
        String path = FileUtil.combineUnixPath(root, entry.getTypeName() + entry.getResConfig().getQualifiers());
        return FileUtil.combineUnixPath(path, this.getSimpleName());
    }

    public Entry pickOne() {
        if (this.mSelectedEntry == null) {
            this.mSelectedEntry = this.selectMatching();
        }
        return this.mSelectedEntry;
    }

    public String getFilePath() {
        return this.getInputSource().getAlias();
    }

    public void setFilePath(String filePath) {
        this.getInputSource().setAlias(filePath);
        for (Entry entry : this) {
            ResValue resValue = entry.getResValue();
            if (resValue == null) continue;
            resValue.setValueAsString(filePath);
        }
    }

    public InputSource getInputSource() {
        return this.inputSource;
    }

    public boolean isBinaryXml() {
        BlockInputSource bis2;
        Object block;
        if (this.mBinXmlChecked) {
            return this.mBinXml;
        }
        this.mBinXmlChecked = true;
        InputSource inputSource = this.getInputSource();
        if (inputSource instanceof XMLEncodeSource || inputSource instanceof JsonXmlInputSource) {
            this.mBinXml = true;
        } else if (inputSource instanceof BlockInputSource && (block = (bis2 = (BlockInputSource)inputSource).getBlock()) instanceof ResXmlDocument) {
            this.mBinXml = true;
        }
        if (!this.mBinXml) {
            try {
                this.mBinXml = ResXmlDocument.isResXmlBlock(inputSource.getBytes(8));
            }
            catch (IOException bis2) {
                // empty catch block
            }
            if (!this.mBinXml && this.getFilePath().endsWith(".xml")) {
                try {
                    ResXmlDocument resXmlDocument = this.readAsXmlDocument();
                    this.mBinXml = !resXmlDocument.getStringPool().isEmpty();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.mBinXml;
    }

    public File buildOutFile(File dir) {
        String path = this.getFilePath();
        path = path.replace('/', File.separatorChar);
        return new File(dir, path);
    }

    public String buildPath() {
        String root = this.getRootNameFromPath();
        if (StringsUtil.isEmpty(root)) {
            root = PackageBlock.RES_DIRECTORY_NAME;
        }
        return this.buildPath(root);
    }

    public String buildPath(String root) {
        Entry entry = this.pickOne();
        StringBuilder builder = new StringBuilder();
        if (root != null) {
            builder.append(root);
            if (!root.endsWith("/")) {
                builder.append('/');
            }
        }
        builder.append(entry.getTypeName());
        builder.append(entry.getResConfig().getQualifiers());
        builder.append('/');
        builder.append(entry.getName());
        builder.append(this.getFileExtension());
        return builder.toString();
    }

    private Entry selectMatching() {
        int size = this.size();
        if (size < 2) {
            return this.getFirst();
        }
        String typeName = this.getTypeNameFromPath();
        if (typeName == null) {
            return this.getFirst();
        }
        List<Entry> typeMatchingList = CollectionUtil.toList(this.iterator(entry -> typeName.equals(entry.getTypeName())));
        if (typeMatchingList.isEmpty()) {
            return this.getFirst();
        }
        if (typeMatchingList.size() == 1) {
            return typeMatchingList.get(0);
        }
        String entryName = this.getEntryNameFromPath();
        if (entryName == null) {
            return typeMatchingList.get(0);
        }
        List<Entry> nameMatchingList = CollectionUtil.toList(this.iterator(entry -> entryName.equals(entry.getName())));
        if (nameMatchingList.isEmpty()) {
            return typeMatchingList.get(0);
        }
        return this.selectConfigMatching(nameMatchingList);
    }

    private Entry selectConfigMatching(List<Entry> candidates) {
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        ResConfig resConfig = this.getResConfigFromPath();
        Entry result = null;
        for (Entry entry : candidates) {
            ResConfig config = entry.getResConfig();
            if (config.equals(resConfig)) {
                return entry;
            }
            if (result != null && (result.getResConfig().isDefault() || !config.isDefault())) continue;
            result = entry;
        }
        return result;
    }

    private ResConfig getResConfigFromPath() {
        String[] split = this.splitPath();
        ResConfig resConfig = null;
        if (split.length == 3) {
            String qualifiers = split[1];
            int i = qualifiers.indexOf(45);
            qualifiers = i > 0 ? qualifiers.substring(i) : StringsUtil.EMPTY;
            resConfig = ResConfig.parse(qualifiers);
        }
        return resConfig;
    }

    public String getTypeNameFromPath() {
        int i;
        String[] split = this.splitPath();
        String type = null;
        if (split.length == 3 && (i = (type = split[1]).indexOf(45)) > 0) {
            type = type.substring(0, i);
        }
        return type;
    }

    public String getEntryNameFromPath() {
        String[] split = this.splitPath();
        String name = null;
        if (split.length == 3) {
            name = split[2];
            String ninePng = EXT_9_PNG;
            if (name.endsWith(ninePng)) {
                name = name.substring(0, name.length() - ninePng.length());
            } else {
                int i = name.lastIndexOf(46);
                if (i > 0) {
                    name = name.substring(0, i);
                }
            }
        }
        return name;
    }

    public String getRootNameFromPath() {
        String[] split = this.splitPath();
        if (split.length > 1) {
            return split[0];
        }
        return null;
    }

    public String getSimpleName() {
        String[] split = this.splitPath();
        return split[split.length - 1];
    }

    private String[] splitPath() {
        return StringsUtil.split(this.getFilePath(), '/', true);
    }

    public String getFileExtension() {
        String ext = this.mFileExtension;
        if (ext == null) {
            this.mFileExtension = ext = this.computeFileExtension();
        }
        return ext;
    }

    private String computeFileExtension() {
        if (this.isBinaryXml()) {
            return ".xml";
        }
        String path = this.getFilePath();
        if (path.endsWith(EXT_9_PNG)) {
            return EXT_9_PNG;
        }
        int i = path.lastIndexOf(46);
        if (i > 0) {
            return path.substring(i);
        }
        String ext = null;
        try {
            ext = FileMagic.getExtensionFromMagic(this.getInputSource());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ext == null) {
            ext = StringsUtil.EMPTY;
        }
        return ext;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ResFile)) {
            return false;
        }
        ResFile resFile = (ResFile)obj;
        return this.getFilePath().equals(resFile.getFilePath());
    }

    public int hashCode() {
        return this.getFilePath().hashCode();
    }

    public String toString() {
        return this.getFilePath();
    }
}

