/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleDecoder;
import com.reandroid.apk.ResFile;
import com.reandroid.app.AndroidManifest;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.Overlayable;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.coder.xml.XmlCoder;
import com.reandroid.arsc.list.OverlayableList;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.io.IOUtil;
import com.reandroid.xml.XMLFactory;
import com.reandroid.xml.XmlIndentingSerializer;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlSerializer;

public class ApkModuleXmlDecoder
extends ApkModuleDecoder
implements Predicate<Entry> {
    private final Map<Integer, Set<ResConfig>> decodedEntries = new HashMap<Integer, Set<ResConfig>>();
    private boolean keepResPath;

    public ApkModuleXmlDecoder(ApkModule apkModule) {
        super(apkModule);
    }

    public void setKeepResPath(boolean keepResPath) {
        this.keepResPath = keepResPath;
    }

    public boolean keepResPath() {
        return this.keepResPath;
    }

    @Override
    void initialize() {
        super.initialize();
        this.validateResourceNames();
    }

    @Override
    public void decodeResourceTable(File mainDirectory) throws IOException {
        TableBlock tableBlock = this.getApkModule().getTableBlock();
        this.decodeTableBlock(mainDirectory, tableBlock);
        this.decodeResFiles(mainDirectory);
        this.decodeValues(mainDirectory, tableBlock);
        this.decodeOverlayable(mainDirectory, tableBlock);
    }

    private void decodeTableBlock(File mainDirectory, TableBlock tableBlock) throws IOException {
        try {
            this.decodePackageInfo(mainDirectory, tableBlock);
            this.decodePublicXml(mainDirectory, tableBlock);
            this.addDecodedPath(TableBlock.FILE_NAME);
        }
        catch (IOException exception) {
            this.logOrThrow("Error decoding resource table", exception);
        }
    }

    private void decodePackageInfo(File mainDirectory, TableBlock tableBlock) throws IOException {
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            this.decodePackageInfo(mainDirectory, packageBlock);
        }
    }

    private void decodePackageInfo(File mainDirectory, PackageBlock packageBlock) throws IOException {
        File packageDirectory = ApkModuleXmlDecoder.toPackageDirectory(mainDirectory, packageBlock);
        File packageJsonFile = new File(packageDirectory, PackageBlock.JSON_FILE_NAME);
        JSONObject jsonObject = packageBlock.toJson(false);
        jsonObject.write(packageJsonFile);
    }

    private void decodeResFiles(File mainDirectory) throws IOException {
        if (this.keepResPath()) {
            this.logMessage("Res files: " + TableBlock.RES_FILES_DIRECTORY_NAME);
        } else {
            this.logMessage("Res files: " + TableBlock.DIRECTORY_NAME);
        }
        List<ResFile> resFileList = this.getApkModule().listResFiles();
        for (ResFile resFile : resFileList) {
            this.decodeResFile(mainDirectory, resFile);
        }
    }

    private void decodeResFile(File mainDirectory, ResFile resFile) throws IOException {
        if (resFile.isBinaryXml()) {
            try {
                this.decodeResXml(mainDirectory, resFile);
            }
            catch (Exception ex) {
                this.logOrThrow("Failed to decode: " + resFile.getFilePath(), ex);
            }
            return;
        }
        String path = resFile.getFilePath();
        if (path.endsWith(".xml")) {
            this.logMessage("Ignore non bin xml: " + path);
            return;
        }
        this.decodeResRaw(mainDirectory, resFile);
    }

    private void decodeResRaw(File mainDirectory, ResFile resFile) throws IOException {
        Entry entry = resFile.pickOne();
        PackageBlock packageBlock = entry.getPackageBlock();
        File file = this.toDecodeResFile(mainDirectory, resFile, packageBlock);
        InputSource inputSource = resFile.getInputSource();
        this.logVerbose(inputSource.getAlias());
        inputSource.write(file);
        if (!this.keepResPath()) {
            this.addDecodedEntry(entry);
        }
        this.addDecodedPath(inputSource.getAlias());
    }

    private void decodeResXml(File mainDirectory, ResFile resFile) throws IOException {
        Entry entry = resFile.pickOne();
        PackageBlock packageBlock = entry.getPackageBlock();
        File file = this.toDecodeResFile(mainDirectory, resFile, packageBlock);
        InputSource inputSource = resFile.getInputSource();
        this.logVerbose(inputSource.getAlias());
        this.serializeXml(packageBlock, resFile.getInputSource(), file);
        if (!this.keepResPath()) {
            this.addDecodedEntry(entry);
        }
        this.addDecodedPath(inputSource.getAlias());
    }

    private File toDecodeResFile(File mainDirectory, ResFile resFile, PackageBlock packageBlock) {
        File dir;
        String path;
        if (this.keepResPath()) {
            path = resFile.getInputSource().getAlias();
            dir = new File(mainDirectory, TableBlock.RES_FILES_DIRECTORY_NAME);
        } else {
            path = resFile.buildPath(PackageBlock.RES_DIRECTORY_NAME);
            dir = ApkModuleXmlDecoder.toPackageDirectory(mainDirectory, packageBlock);
            resFile.setFilePath(path);
        }
        path = path.replace('/', File.separatorChar);
        return new File(dir, path);
    }

    private void decodePublicXml(File mainDirectory, TableBlock tableBlock) throws IOException {
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            this.decodePublicXml(mainDirectory, packageBlock);
        }
        if (tableBlock.size() == 0) {
            this.decodeEmptyTable(mainDirectory, tableBlock);
        }
    }

    private void decodePublicXml(File mainDirectory, PackageBlock packageBlock) throws IOException {
        File packageDirectory = ApkModuleXmlDecoder.toPackageDirectory(mainDirectory, packageBlock);
        this.logMessage("public.xml: " + packageBlock.getName() + " -> " + packageDirectory.getName());
        File file = new File(packageDirectory, PackageBlock.RES_DIRECTORY_NAME);
        file = new File(file, PackageBlock.VALUES_DIRECTORY_NAME);
        file = new File(file, PackageBlock.PUBLIC_XML);
        packageBlock.serializePublicXml(file);
    }

    private void decodeEmptyTable(File mainDirectory, TableBlock tableBlock) throws IOException {
        this.logMessage("Decoding empty table ...");
        File packageDirectory = new File(mainDirectory, TableBlock.DIRECTORY_NAME);
        packageDirectory = new File(packageDirectory, PackageBlock.DIRECTORY_NAME_PREFIX + "1");
        this.logMessage("Empty public.xml: " + packageDirectory.getName());
        File file = new File(packageDirectory, PackageBlock.RES_DIRECTORY_NAME);
        file = new File(file, PackageBlock.VALUES_DIRECTORY_NAME);
        file = new File(file, PackageBlock.PUBLIC_XML);
        PackageBlock packageBlock = tableBlock.pickOrEmptyPackage();
        packageBlock.serializePublicXml(file);
    }

    @Override
    public void decodeAndroidManifest(File mainDirectory) throws IOException {
        if (this.containsDecodedPath(AndroidManifest.FILE_NAME)) {
            return;
        }
        if (!this.getApkModule().hasAndroidManifest()) {
            this.decodeEmptyAndroidManifestXml(mainDirectory);
        } else if (this.isExcluded(AndroidManifest.FILE_NAME)) {
            this.decodeAndroidManifestBin(mainDirectory);
        } else {
            this.decodeAndroidManifestXml(mainDirectory);
        }
    }

    private void decodeEmptyAndroidManifestXml(File mainDirectory) throws IOException {
        this.logMessage("WARN: Missing " + AndroidManifest.FILE_NAME + ", could be framework apk or you are decompiling wrong apk file");
        File file = new File(mainDirectory, AndroidManifest.FILE_NAME);
        XmlSerializer serializer = XMLFactory.newSerializer(file);
        serializer.startDocument("utf-8", null);
        serializer.text("\n");
        serializer.startTag(null, AndroidManifest.EMPTY_MANIFEST_TAG);
        serializer.endTag(null, AndroidManifest.EMPTY_MANIFEST_TAG);
        serializer.endDocument();
        serializer.flush();
        IOUtil.close(serializer);
        this.addDecodedPath(AndroidManifest.FILE_NAME);
    }

    private void decodeAndroidManifestXml(File mainDirectory) throws IOException {
        AndroidManifestBlock manifestBlock = this.getApkModule().getAndroidManifest();
        File file = new File(mainDirectory, AndroidManifest.FILE_NAME);
        this.logMessage("Decoding: " + file.getName());
        PackageBlock packageBlock = manifestBlock.getPackageBlock();
        if (packageBlock == null) {
            int packageId = manifestBlock.guessCurrentPackageId();
            TableBlock tableBlock = this.getApkModule().getTableBlock();
            packageBlock = tableBlock.pickOne(packageId);
            if (packageBlock == null) {
                packageBlock = tableBlock.pickOne();
            }
        }
        this.serializeXml(packageBlock, manifestBlock, file);
        this.addDecodedPath(AndroidManifest.FILE_NAME);
    }

    private void decodeAndroidManifestBin(File mainDirectory) throws IOException {
        File file = new File(mainDirectory, AndroidManifest.FILE_NAME_BIN);
        this.logMessage("Decode manifest binary: " + file.getName());
        ApkModule apkModule = this.getApkModule();
        InputSource inputSource = apkModule.getManifestOriginalSource();
        if (inputSource == null) {
            inputSource = apkModule.getInputSource(AndroidManifest.FILE_NAME);
        }
        inputSource.write(file);
        this.addDecodedPath(AndroidManifest.FILE_NAME);
    }

    private void serializeXml(PackageBlock packageBlock, ResXmlDocument document, File outFile) throws IOException {
        if (packageBlock != null && document.getPackageBlock() == null) {
            document.setPackageBlock(packageBlock);
        }
        XmlSerializer serializer = XMLFactory.newSerializer(outFile, document.getEncoding());
        document.serialize(serializer);
        IOUtil.close(serializer);
    }

    private void serializeXml(PackageBlock packageBlock, InputSource inputSource, File outFile) throws IOException {
        ResXmlDocument document = new ResXmlDocument();
        document.readBytes(inputSource.openStream());
        document.setPackageBlock(packageBlock);
        this.serializeXml(packageBlock, document, outFile);
    }

    private void addDecodedEntry(Entry entry) {
        if (entry.isNull()) {
            return;
        }
        int resourceId = entry.getResourceId();
        Set<ResConfig> resConfigSet = this.decodedEntries.get(resourceId);
        if (resConfigSet == null) {
            resConfigSet = new HashSet<ResConfig>();
            this.decodedEntries.put(resourceId, resConfigSet);
        }
        resConfigSet.add(entry.getResConfig());
    }

    private boolean containsDecodedEntry(Entry entry) {
        Set<ResConfig> resConfigSet = this.decodedEntries.get(entry.getResourceId());
        if (resConfigSet == null) {
            return false;
        }
        return resConfigSet.contains(entry.getResConfig());
    }

    private void decodeValues(File mainDirectory, TableBlock tableBlock) throws IOException {
        File resourcesDir = new File(mainDirectory, TableBlock.DIRECTORY_NAME);
        XmlCoder xmlCoder = XmlCoder.getInstance();
        xmlCoder.VALUES_XML.decodeTable(resourcesDir, tableBlock, (Predicate<Entry>)this);
    }

    private void decodeOverlayable(File mainDirectory, TableBlock tableBlock) throws IOException {
        for (PackageBlock packageBlock : tableBlock) {
            this.decodeOverlayable(mainDirectory, packageBlock);
        }
    }

    private void decodeOverlayable(File mainDirectory, PackageBlock packageBlock) throws IOException {
        OverlayableList overlayableList = packageBlock.getOverlayableList();
        if (overlayableList.isEmpty()) {
            return;
        }
        this.logMessage("Decode: overlayable");
        File packageDirectory = ApkModuleXmlDecoder.toPackageDirectory(mainDirectory, packageBlock);
        File file = new File(packageDirectory, PackageBlock.RES_DIRECTORY_NAME);
        file = new File(file, PackageBlock.VALUES_DIRECTORY_NAME);
        file = new File(file, Overlayable.FILE_NAME_XML);
        XmlIndentingSerializer serializer = new XmlIndentingSerializer(XMLFactory.newSerializer(file));
        XMLFactory.setEnableIndentAttributes(serializer, false);
        overlayableList.serialize(serializer);
    }

    @Override
    public boolean test(Entry entry) {
        return this.containsDecodedEntry(entry);
    }
}

