/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleDecoder;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import java.io.File;
import java.io.IOException;

public class ApkModuleRawDecoder
extends ApkModuleDecoder {
    public ApkModuleRawDecoder(ApkModule apkModule) {
        super(apkModule);
        apkModule.setLoadDefaultFramework(false);
    }

    @Override
    public void decodeResourceTable(File mainDirectory) throws IOException {
        ApkModule apkModule = this.getApkModule();
        apkModule.discardTableBlockChanges();
        InputSource inputSource = apkModule.getTableOriginalSource();
        if (inputSource == null) {
            this.logMessage("File NOT found: " + TableBlock.FILE_NAME);
        } else {
            File file = new File(mainDirectory, TableBlock.FILE_NAME);
            inputSource.write(file);
            this.addDecodedPath(TableBlock.FILE_NAME);
        }
    }

    @Override
    void decodeAndroidManifest(File mainDirectory) throws IOException {
        ApkModule apkModule = this.getApkModule();
        apkModule.discardManifestChanges();
        InputSource inputSource = apkModule.getManifestOriginalSource();
        if (inputSource == null) {
            this.logMessage("File NOT found: " + AndroidManifestBlock.FILE_NAME);
        } else {
            File file = new File(mainDirectory, AndroidManifestBlock.FILE_NAME_BIN);
            inputSource.write(file);
            this.addDecodedPath(AndroidManifestBlock.FILE_NAME);
        }
    }
}

