/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.metrics;

import org.conscrypt.Platform;
import org.conscrypt.metrics.OptionalMethod;

public class ReflexiveStatsEvent {
    private static final OptionalMethod newBuilder;
    private static final Class<?> c_statsEvent;
    private static final boolean sdkVersionBiggerThan32;
    private final Object statsEvent;

    private static Class<?> initStatsEventClass() {
        try {
            return Class.forName("android.util.StatsEvent");
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    private ReflexiveStatsEvent(Object statsEvent) {
        this.statsEvent = statsEvent;
    }

    public Object getStatsEvent() {
        return this.statsEvent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    public static ReflexiveStatsEvent buildEvent(int atomId, boolean success, int protocol, int cipherSuite, int duration, int source, int[] uids) {
        Builder builder = ReflexiveStatsEvent.newBuilder();
        builder.setAtomId(atomId);
        builder.writeBoolean(success);
        builder.writeInt(protocol);
        builder.writeInt(cipherSuite);
        builder.writeInt(duration);
        builder.writeInt(source);
        builder.writeIntArray(uids);
        builder.usePooledBuffer();
        return builder.build();
    }

    @Deprecated
    public static ReflexiveStatsEvent buildEvent(int atomId, boolean success, int protocol, int cipherSuite, int duration, int source) {
        Builder builder = ReflexiveStatsEvent.newBuilder();
        builder.setAtomId(atomId);
        builder.writeBoolean(success);
        builder.writeInt(protocol);
        builder.writeInt(cipherSuite);
        builder.writeInt(duration);
        builder.writeInt(source);
        builder.usePooledBuffer();
        return builder.build();
    }

    static /* synthetic */ OptionalMethod access$100() {
        return newBuilder;
    }

    static {
        c_statsEvent = ReflexiveStatsEvent.initStatsEventClass();
        newBuilder = new OptionalMethod(c_statsEvent, "newBuilder", new Class[0]);
        sdkVersionBiggerThan32 = Platform.isSdkGreater(32);
    }

    public static final class Builder {
        private static final Class<?> c_statsEvent_Builder = Builder.initStatsEventBuilderClass();
        private static final OptionalMethod setAtomId = new OptionalMethod(c_statsEvent_Builder, "setAtomId", Integer.TYPE);
        private static final OptionalMethod writeBoolean = new OptionalMethod(c_statsEvent_Builder, "writeBoolean", Boolean.TYPE);
        private static final OptionalMethod writeInt = new OptionalMethod(c_statsEvent_Builder, "writeInt", Integer.TYPE);
        private static final OptionalMethod build = new OptionalMethod(c_statsEvent_Builder, "build", new Class[0]);
        private static final OptionalMethod usePooledBuffer = new OptionalMethod(c_statsEvent_Builder, "usePooledBuffer", new Class[0]);
        private static final OptionalMethod writeIntArray = new OptionalMethod(c_statsEvent_Builder, "writeIntArray", int[].class);
        private final Object builder = ReflexiveStatsEvent.access$100().invokeStatic(new Object[0]);

        private static Class<?> initStatsEventBuilderClass() {
            try {
                return Class.forName("android.util.StatsEvent$Builder");
            }
            catch (ClassNotFoundException ignored) {
                return null;
            }
        }

        private Builder() {
        }

        public Builder setAtomId(int atomId) {
            setAtomId.invoke(this.builder, atomId);
            return this;
        }

        public Builder writeBoolean(boolean value) {
            writeBoolean.invoke(this.builder, value);
            return this;
        }

        public Builder writeInt(int value) {
            writeInt.invoke(this.builder, value);
            return this;
        }

        public void usePooledBuffer() {
            usePooledBuffer.invoke(this.builder, new Object[0]);
        }

        public Builder writeIntArray(int[] values) {
            if (sdkVersionBiggerThan32) {
                writeIntArray.invoke(this.builder, new Object[]{values});
            }
            return this;
        }

        public ReflexiveStatsEvent build() {
            Object statsEvent = build.invoke(this.builder, new Object[0]);
            return new ReflexiveStatsEvent(statsEvent);
        }
    }
}

