/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.metrics;

public enum CipherSuite {
    UNKNOWN_CIPHER_SUITE(0),
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA(49162),
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA(49172),
    TLS_RSA_WITH_AES_256_CBC_SHA(53),
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA(49161),
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA(49171),
    TLS_RSA_WITH_AES_128_CBC_SHA(47),
    TLS_RSA_WITH_3DES_EDE_CBC_SHA(10),
    TLS_RSA_WITH_AES_128_GCM_SHA256(156),
    TLS_RSA_WITH_AES_256_GCM_SHA384(157),
    TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256(49199),
    TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384(49200),
    TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256(49195),
    TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384(49196),
    TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256(52393),
    TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256(52392),
    TLS_PSK_WITH_AES_128_CBC_SHA(140),
    TLS_PSK_WITH_AES_256_CBC_SHA(141),
    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA(49205),
    TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA(49206),
    TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256(52396),
    TLS_AES_128_GCM_SHA256(4865),
    TLS_AES_256_GCM_SHA384(4866),
    TLS_CHACHA20_POLY1305_SHA256(4867),
    TLS_CIPHER_FAILED(65535);

    final int id;

    public int getId() {
        return this.id;
    }

    public static CipherSuite forName(String name) {
        if ("SSL_RSA_WITH_3DES_EDE_CBC_SHA".equals(name)) {
            return TLS_RSA_WITH_3DES_EDE_CBC_SHA;
        }
        try {
            return CipherSuite.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN_CIPHER_SUITE;
        }
    }

    private CipherSuite(int id) {
        this.id = id;
    }
}

