/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.ct;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Objects;
import org.conscrypt.ct.CertificateEntry;
import org.conscrypt.ct.SerializationException;
import org.conscrypt.ct.SignedCertificateTimestamp;
import org.conscrypt.ct.VerifiedSCT;

public class LogInfo {
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_PENDING = 1;
    public static final int STATE_QUALIFIED = 2;
    public static final int STATE_USABLE = 3;
    public static final int STATE_READONLY = 4;
    public static final int STATE_RETIRED = 5;
    public static final int STATE_REJECTED = 6;
    private final byte[] logId;
    private final PublicKey publicKey;
    private final int state;
    private final long stateTimestamp;
    private final String description;
    private final String url;
    private final String operator;

    private LogInfo(Builder builder) {
        Objects.requireNonNull(builder.logId);
        Objects.requireNonNull(builder.publicKey);
        Objects.requireNonNull(builder.url);
        Objects.requireNonNull(builder.operator);
        this.logId = builder.logId;
        this.publicKey = builder.publicKey;
        this.state = builder.state;
        this.stateTimestamp = builder.stateTimestamp;
        this.description = builder.description;
        this.url = builder.url;
        this.operator = builder.operator;
    }

    public byte[] getID() {
        return this.logId;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public int getState() {
        return this.state;
    }

    public int getStateAt(long when) {
        if (when >= this.stateTimestamp) {
            return this.state;
        }
        return 0;
    }

    public long getStateTimestamp() {
        return this.stateTimestamp;
    }

    public String getOperator() {
        return this.operator;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LogInfo)) {
            return false;
        }
        LogInfo that = (LogInfo)other;
        return this.state == that.state && this.description.equals(that.description) && this.url.equals(that.url) && this.operator.equals(that.operator) && this.stateTimestamp == that.stateTimestamp && Arrays.equals(this.logId, that.logId);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.logId), this.description, this.url, this.state, this.stateTimestamp, this.operator);
    }

    public VerifiedSCT.Status verifySingleSCT(SignedCertificateTimestamp sct, CertificateEntry entry) {
        Signature signature;
        byte[] toVerify;
        if (!Arrays.equals(sct.getLogID(), this.getID())) {
            return VerifiedSCT.Status.UNKNOWN_LOG;
        }
        try {
            toVerify = sct.encodeTBS(entry);
        }
        catch (SerializationException e) {
            return VerifiedSCT.Status.INVALID_SCT;
        }
        try {
            String algorithm = sct.getSignature().getAlgorithm();
            signature = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return VerifiedSCT.Status.INVALID_SCT;
        }
        try {
            signature.initVerify(this.publicKey);
        }
        catch (InvalidKeyException e) {
            return VerifiedSCT.Status.INVALID_SCT;
        }
        try {
            signature.update(toVerify);
            if (!signature.verify(sct.getSignature().getSignature())) {
                return VerifiedSCT.Status.INVALID_SIGNATURE;
            }
            return VerifiedSCT.Status.VALID;
        }
        catch (SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private byte[] logId;
        private PublicKey publicKey;
        private int state;
        private long stateTimestamp;
        private String description;
        private String url;
        private String operator;

        public Builder setPublicKey(PublicKey publicKey) {
            Objects.requireNonNull(publicKey);
            this.publicKey = publicKey;
            try {
                this.logId = MessageDigest.getInstance("SHA-256").digest(publicKey.getEncoded());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder setState(int state, long timestamp) {
            if (state < 0 || state > 6) {
                throw new IllegalArgumentException("invalid state value");
            }
            this.state = state;
            this.stateTimestamp = timestamp;
            return this;
        }

        public Builder setDescription(String description) {
            Objects.requireNonNull(description);
            this.description = description;
            return this;
        }

        public Builder setUrl(String url) {
            Objects.requireNonNull(url);
            this.url = url;
            return this;
        }

        public Builder setOperator(String operator) {
            Objects.requireNonNull(operator);
            this.operator = operator;
            return this;
        }

        public LogInfo build() {
            return new LogInfo(this);
        }
    }
}

