/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLX25519PrivateKey;
import org.conscrypt.OpenSSLX25519PublicKey;

public final class OpenSSLXDHKeyPairGenerator
extends KeyPairGenerator {
    private static final String ALGORITHM = "XDH";

    public OpenSSLXDHKeyPairGenerator() {
        super(ALGORITHM);
    }

    @Override
    public KeyPair generateKeyPair() {
        byte[] publicKeyBytes = new byte[32];
        byte[] privateKeyBytes = new byte[32];
        NativeCrypto.X25519_keypair(publicKeyBytes, privateKeyBytes);
        return new KeyPair(new OpenSSLX25519PublicKey(publicKeyBytes), new OpenSSLX25519PrivateKey(privateKeyBytes));
    }

    @Override
    public void initialize(int keysize, SecureRandom random) {
        if (keysize != 255) {
            throw new IllegalArgumentException("Only X25519 supported");
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec param, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No AlgorithmParameterSpec classes are supported");
    }
}

