/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v1;

import java.util.Comparator;

public enum DigestAlgorithm {
    SHA1("SHA-1"),
    SHA256("SHA-256");

    private final String mJcaMessageDigestAlgorithm;
    public static Comparator<DigestAlgorithm> BY_STRENGTH_COMPARATOR;

    private DigestAlgorithm(String jcaMessageDigestAlgoritm) {
        this.mJcaMessageDigestAlgorithm = jcaMessageDigestAlgoritm;
    }

    String getJcaMessageDigestAlgorithm() {
        return this.mJcaMessageDigestAlgorithm;
    }

    static {
        BY_STRENGTH_COMPARATOR = new StrengthComparator();
    }

    private static class StrengthComparator
    implements Comparator<DigestAlgorithm> {
        private StrengthComparator() {
        }

        @Override
        public int compare(DigestAlgorithm a1, DigestAlgorithm a2) {
            switch (a1.ordinal()) {
                case 0: {
                    switch (a2.ordinal()) {
                        case 0: {
                            return 0;
                        }
                        case 1: {
                            return -1;
                        }
                    }
                    throw new RuntimeException("Unsupported algorithm: " + (Object)((Object)a2));
                }
                case 1: {
                    switch (a2.ordinal()) {
                        case 0: {
                            return 1;
                        }
                        case 1: {
                            return 0;
                        }
                    }
                    throw new RuntimeException("Unsupported algorithm: " + (Object)((Object)a2));
                }
            }
            throw new RuntimeException("Unsupported algorithm: " + (Object)((Object)a1));
        }
    }
}

