/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked;

import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedClassDef;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethod;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethodImplementation;
import com.android.tools.smali.dexlib2.dexbacked.DexBuffer;
import com.android.tools.smali.dexlib2.dexbacked.DexReader;
import com.android.tools.smali.dexlib2.dexbacked.raw.HeaderItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.MapItem;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedCallSiteReference;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedFieldReference;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedMethodHandleReference;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedMethodProtoReference;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedMethodReference;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedStringReference;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedTypeReference;
import com.android.tools.smali.dexlib2.dexbacked.util.FixedSizeList;
import com.android.tools.smali.dexlib2.dexbacked.util.FixedSizeSet;
import com.android.tools.smali.dexlib2.iface.DexFile;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import com.android.tools.smali.dexlib2.util.DexUtil;
import com.android.tools.smali.util.InputStreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DexBackedDexFile
implements DexFile {
    private final DexBuffer dexBuffer;
    private final DexBuffer dataBuffer;
    @Nonnull
    private final Opcodes opcodes;
    private final int fileSize;
    private final int stringCount;
    private final int stringStartOffset;
    private final int typeCount;
    private final int typeStartOffset;
    private final int protoCount;
    private final int protoStartOffset;
    private final int fieldCount;
    private final int fieldStartOffset;
    private final int methodCount;
    private final int methodStartOffset;
    private final int classCount;
    private final int classStartOffset;
    private final int mapOffset;
    private final int hiddenApiRestrictionsOffset;
    private OptionalIndexedSection<String> stringSection = new OptionalIndexedSection<String>(){

        @Override
        public String get(int index) {
            int stringOffset = this.getOffset(index);
            int stringDataOffset = DexBackedDexFile.this.dexBuffer.readSmallUint(stringOffset);
            DexReader<? extends DexBuffer> reader = DexBackedDexFile.this.dataBuffer.readerAt(stringDataOffset);
            int utf16Length = reader.readSmallUleb128();
            return reader.readString(utf16Length);
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.stringCount;
        }

        @Override
        @Nullable
        public String getOptional(int index) {
            if (index == -1) {
                return null;
            }
            return this.get(index);
        }

        @Override
        public int getOffset(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid string index %d, not in [0, %d)", index, this.size()));
            }
            return DexBackedDexFile.this.stringStartOffset + index * 4;
        }
    };
    private OptionalIndexedSection<String> typeSection = new OptionalIndexedSection<String>(){

        @Override
        public String get(int index) {
            int typeOffset = this.getOffset(index);
            int stringIndex = DexBackedDexFile.this.dexBuffer.readSmallUint(typeOffset);
            return (String)DexBackedDexFile.this.getStringSection().get(stringIndex);
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.typeCount;
        }

        @Override
        @Nullable
        public String getOptional(int index) {
            if (index == -1) {
                return null;
            }
            return this.get(index);
        }

        @Override
        public int getOffset(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid type index %d, not in [0, %d)", index, this.size()));
            }
            return DexBackedDexFile.this.typeStartOffset + index * 4;
        }
    };
    private IndexedSection<DexBackedFieldReference> fieldSection = new IndexedSection<DexBackedFieldReference>(){

        @Override
        public DexBackedFieldReference get(int index) {
            return new DexBackedFieldReference(DexBackedDexFile.this, index);
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.fieldCount;
        }

        @Override
        public int getOffset(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid field index %d, not in [0, %d)", index, this.size()));
            }
            return DexBackedDexFile.this.fieldStartOffset + index * 8;
        }
    };
    private IndexedSection<DexBackedMethodReference> methodSection = new IndexedSection<DexBackedMethodReference>(){

        @Override
        public DexBackedMethodReference get(int index) {
            return new DexBackedMethodReference(DexBackedDexFile.this, index);
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.methodCount;
        }

        @Override
        public int getOffset(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid method index %d, not in [0, %d)", index, this.size()));
            }
            return DexBackedDexFile.this.methodStartOffset + index * 8;
        }
    };
    private IndexedSection<DexBackedMethodProtoReference> protoSection = new IndexedSection<DexBackedMethodProtoReference>(){

        @Override
        public DexBackedMethodProtoReference get(int index) {
            return new DexBackedMethodProtoReference(DexBackedDexFile.this, index);
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.protoCount;
        }

        @Override
        public int getOffset(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid proto index %d, not in [0, %d)", index, this.size()));
            }
            return DexBackedDexFile.this.protoStartOffset + index * 12;
        }
    };
    private IndexedSection<DexBackedClassDef> classSection = new IndexedSection<DexBackedClassDef>(){

        @Override
        public DexBackedClassDef get(int index) {
            return new DexBackedClassDef(DexBackedDexFile.this, this.getOffset(index), DexBackedDexFile.this.readHiddenApiRestrictionsOffset(index));
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.classCount;
        }

        @Override
        public int getOffset(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid class index %d, not in [0, %d)", index, this.size()));
            }
            return DexBackedDexFile.this.classStartOffset + index * 32;
        }
    };
    private IndexedSection<DexBackedCallSiteReference> callSiteSection = new IndexedSection<DexBackedCallSiteReference>(){

        @Override
        public DexBackedCallSiteReference get(int index) {
            return new DexBackedCallSiteReference(DexBackedDexFile.this, index);
        }

        @Override
        public int size() {
            MapItem mapItem = DexBackedDexFile.this.getMapItemForSection(7);
            if (mapItem == null) {
                return 0;
            }
            return mapItem.getItemCount();
        }

        @Override
        public int getOffset(int index) {
            MapItem mapItem = DexBackedDexFile.this.getMapItemForSection(7);
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid callsite index %d, not in [0, %d)", index, this.size()));
            }
            return mapItem.getOffset() + index * 4;
        }
    };
    private IndexedSection<DexBackedMethodHandleReference> methodHandleSection = new IndexedSection<DexBackedMethodHandleReference>(){

        @Override
        public DexBackedMethodHandleReference get(int index) {
            return new DexBackedMethodHandleReference(DexBackedDexFile.this, index);
        }

        @Override
        public int size() {
            MapItem mapItem = DexBackedDexFile.this.getMapItemForSection(8);
            if (mapItem == null) {
                return 0;
            }
            return mapItem.getItemCount();
        }

        @Override
        public int getOffset(int index) {
            MapItem mapItem = DexBackedDexFile.this.getMapItemForSection(8);
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid method handle index %d, not in [0, %d)", index, this.size()));
            }
            return mapItem.getOffset() + index * 8;
        }
    };

    protected DexBackedDexFile(@Nullable Opcodes opcodes, @Nonnull byte[] buf, int offset, boolean verifyMagic) {
        this(opcodes, buf, offset, verifyMagic, 0);
    }

    protected DexBackedDexFile(@Nullable Opcodes opcodes, @Nonnull byte[] buf, int offset, boolean verifyMagic, int header_offset) {
        this.dexBuffer = new DexBuffer(buf, offset);
        this.dataBuffer = new DexBuffer(buf, offset + this.getBaseDataOffset());
        int dexVersion = this.getVersion(buf, offset, verifyMagic);
        this.opcodes = opcodes == null ? this.getDefaultOpcodes(dexVersion) : opcodes;
        this.fileSize = this.dexBuffer.readSmallUint(header_offset + 32);
        this.stringCount = this.dexBuffer.readSmallUint(header_offset + 56);
        this.stringStartOffset = this.dexBuffer.readSmallUint(header_offset + 60);
        this.typeCount = this.dexBuffer.readSmallUint(header_offset + 64);
        this.typeStartOffset = this.dexBuffer.readSmallUint(header_offset + 68);
        this.protoCount = this.dexBuffer.readSmallUint(header_offset + 72);
        this.protoStartOffset = this.dexBuffer.readSmallUint(header_offset + 76);
        this.fieldCount = this.dexBuffer.readSmallUint(header_offset + 80);
        this.fieldStartOffset = this.dexBuffer.readSmallUint(header_offset + 84);
        this.methodCount = this.dexBuffer.readSmallUint(header_offset + 88);
        this.methodStartOffset = this.dexBuffer.readSmallUint(header_offset + 92);
        this.classCount = this.dexBuffer.readSmallUint(header_offset + 96);
        this.classStartOffset = this.dexBuffer.readSmallUint(header_offset + 100);
        this.mapOffset = this.dexBuffer.readSmallUint(header_offset + 52);
        MapItem mapItem = this.getMapItemForSection(61440);
        this.hiddenApiRestrictionsOffset = mapItem != null ? mapItem.getOffset() : 0;
        int container_off = 0;
        if (dexVersion >= 41) {
            container_off = this.dexBuffer.readSmallUint(header_offset + 116);
        }
        if (container_off != header_offset) {
            throw new DexUtil.InvalidFile(String.format("Unexpected container offset in header", new Object[0]));
        }
    }

    public int getBaseDataOffset() {
        return 0;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    protected int getVersion(byte[] buf, int offset, boolean verifyMagic) {
        if (verifyMagic) {
            return DexUtil.verifyDexHeader(buf, offset);
        }
        return HeaderItem.getVersion(buf, offset);
    }

    protected Opcodes getDefaultOpcodes(int version) {
        return Opcodes.forDexVersion(version);
    }

    public DexBuffer getBuffer() {
        return this.dexBuffer;
    }

    public DexBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public DexBackedDexFile(@Nullable Opcodes opcodes, @Nonnull DexBuffer buf) {
        this(opcodes, buf.buf, buf.baseOffset);
    }

    public DexBackedDexFile(@Nullable Opcodes opcodes, @Nonnull byte[] buf, int offset) {
        this(opcodes, buf, offset, false);
    }

    public DexBackedDexFile(@Nullable Opcodes opcodes, @Nonnull byte[] buf) {
        this(opcodes, buf, 0, true);
    }

    @Nonnull
    public static DexBackedDexFile fromInputStream(@Nullable Opcodes opcodes, @Nonnull InputStream is) throws IOException {
        DexUtil.verifyDexHeader(is);
        byte[] buf = InputStreamUtil.toByteArray(is);
        return new DexBackedDexFile(opcodes, buf, 0, false);
    }

    @Override
    @Nonnull
    public Opcodes getOpcodes() {
        return this.opcodes;
    }

    public boolean supportsOptimizedOpcodes() {
        return false;
    }

    @Nonnull
    public Set<? extends DexBackedClassDef> getClasses() {
        return new FixedSizeSet<DexBackedClassDef>(){

            @Override
            @Nonnull
            public DexBackedClassDef readItem(int index) {
                return (DexBackedClassDef)DexBackedDexFile.this.getClassSection().get(index);
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.classCount;
            }
        };
    }

    public List<DexBackedStringReference> getStringReferences() {
        return new AbstractList<DexBackedStringReference>(){

            @Override
            public DexBackedStringReference get(int index) {
                if (index < 0 || index >= DexBackedDexFile.this.getStringSection().size()) {
                    throw new IndexOutOfBoundsException();
                }
                return new DexBackedStringReference(DexBackedDexFile.this, index);
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.getStringSection().size();
            }
        };
    }

    public List<DexBackedTypeReference> getTypeReferences() {
        return new AbstractList<DexBackedTypeReference>(){

            @Override
            public DexBackedTypeReference get(int index) {
                if (index < 0 || index >= DexBackedDexFile.this.getTypeSection().size()) {
                    throw new IndexOutOfBoundsException();
                }
                return new DexBackedTypeReference(DexBackedDexFile.this, index);
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.getTypeSection().size();
            }
        };
    }

    public List<? extends Reference> getReferences(int referenceType) {
        switch (referenceType) {
            case 0: {
                return this.getStringReferences();
            }
            case 1: {
                return this.getTypeReferences();
            }
            case 3: {
                return this.getMethodSection();
            }
            case 2: {
                return this.getFieldSection();
            }
            case 4: {
                return this.getMethodSection();
            }
            case 6: {
                return this.getMethodHandleSection();
            }
            case 5: {
                return this.getCallSiteSection();
            }
        }
        throw new IllegalArgumentException(String.format("Invalid reference type: %d", referenceType));
    }

    public List<MapItem> getMapItems() {
        final int mapSize = this.dataBuffer.readSmallUint(this.mapOffset);
        return new FixedSizeList<MapItem>(){

            @Override
            public MapItem readItem(int index) {
                int mapItemOffset = DexBackedDexFile.this.mapOffset + 4 + index * 12;
                return new MapItem(DexBackedDexFile.this, mapItemOffset);
            }

            @Override
            public int size() {
                return mapSize;
            }
        };
    }

    @Nullable
    public MapItem getMapItemForSection(int itemType) {
        for (MapItem mapItem : this.getMapItems()) {
            if (mapItem.getType() != itemType) continue;
            return mapItem;
        }
        return null;
    }

    public OptionalIndexedSection<String> getStringSection() {
        return this.stringSection;
    }

    public OptionalIndexedSection<String> getTypeSection() {
        return this.typeSection;
    }

    public IndexedSection<DexBackedFieldReference> getFieldSection() {
        return this.fieldSection;
    }

    public IndexedSection<DexBackedMethodReference> getMethodSection() {
        return this.methodSection;
    }

    public IndexedSection<DexBackedMethodProtoReference> getProtoSection() {
        return this.protoSection;
    }

    public IndexedSection<DexBackedClassDef> getClassSection() {
        return this.classSection;
    }

    public IndexedSection<DexBackedCallSiteReference> getCallSiteSection() {
        return this.callSiteSection;
    }

    public IndexedSection<DexBackedMethodHandleReference> getMethodHandleSection() {
        return this.methodHandleSection;
    }

    protected DexBackedMethodImplementation createMethodImplementation(@Nonnull DexBackedDexFile dexFile, @Nonnull DexBackedMethod method, int codeOffset) {
        return new DexBackedMethodImplementation(dexFile, method, codeOffset);
    }

    private int readHiddenApiRestrictionsOffset(int classIndex) {
        if (this.hiddenApiRestrictionsOffset == 0) {
            return 0;
        }
        int offset = this.dexBuffer.readInt(this.hiddenApiRestrictionsOffset + 4 + classIndex * 4);
        if (offset == 0) {
            return 0;
        }
        return this.hiddenApiRestrictionsOffset + offset;
    }

    public static abstract class OptionalIndexedSection<T>
    extends IndexedSection<T> {
        @Nullable
        public abstract T getOptional(int var1);
    }

    public static abstract class IndexedSection<T>
    extends AbstractList<T> {
        public abstract int getOffset(int var1);
    }

    public static class NotADexFile
    extends RuntimeException {
        public NotADexFile() {
        }

        public NotADexFile(Throwable cause) {
            super(cause);
        }

        public NotADexFile(String message) {
            super(message);
        }

        public NotADexFile(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

